//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BackupRestoreResponse The definition of a backup restore response body.
//
// swagger:model BackupRestoreResponse
type BackupRestoreResponse struct {

	// Backup backend name e.g. filesystem, gcs, s3.
	Backend string `json:"backend,omitempty"`

	// The list of collections (classes) for which the backup restoration process was started.
	Classes []string `json:"classes"`

	// Error message if backup restoration failed.
	Error string `json:"error,omitempty"`

	// The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.
	ID string `json:"id,omitempty"`

	// Destination path of backup files valid for the selected backend.
	Path string `json:"path,omitempty"`

	// Phase of backup restoration process.
	// Enum: [STARTED TRANSFERRING TRANSFERRED SUCCESS FAILED CANCELED]
	Status *string `json:"status,omitempty"`
}

// Validate validates this backup restore response
func (m *BackupRestoreResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var backupRestoreResponseTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["STARTED","TRANSFERRING","TRANSFERRED","SUCCESS","FAILED","CANCELED"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backupRestoreResponseTypeStatusPropEnum = append(backupRestoreResponseTypeStatusPropEnum, v)
	}
}

const (

	// BackupRestoreResponseStatusSTARTED captures enum value "STARTED"
	BackupRestoreResponseStatusSTARTED string = "STARTED"

	// BackupRestoreResponseStatusTRANSFERRING captures enum value "TRANSFERRING"
	BackupRestoreResponseStatusTRANSFERRING string = "TRANSFERRING"

	// BackupRestoreResponseStatusTRANSFERRED captures enum value "TRANSFERRED"
	BackupRestoreResponseStatusTRANSFERRED string = "TRANSFERRED"

	// BackupRestoreResponseStatusSUCCESS captures enum value "SUCCESS"
	BackupRestoreResponseStatusSUCCESS string = "SUCCESS"

	// BackupRestoreResponseStatusFAILED captures enum value "FAILED"
	BackupRestoreResponseStatusFAILED string = "FAILED"

	// BackupRestoreResponseStatusCANCELED captures enum value "CANCELED"
	BackupRestoreResponseStatusCANCELED string = "CANCELED"
)

// prop value enum
func (m *BackupRestoreResponse) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backupRestoreResponseTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackupRestoreResponse) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this backup restore response based on context it is used
func (m *BackupRestoreResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BackupRestoreResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BackupRestoreResponse) UnmarshalBinary(b []byte) error {
	var res BackupRestoreResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
