//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// C11yVectorBasedQuestion Receive question based on array of collection names (classes), properties and values.
//
// swagger:model C11yVectorBasedQuestion
type C11yVectorBasedQuestion []*C11yVectorBasedQuestionItems0

// Validate validates this c11y vector based question
func (m C11yVectorBasedQuestion) Validate(formats strfmt.Registry) error {
	var res []error

	for i := 0; i < len(m); i++ {
		if swag.IsZero(m[i]) { // not required
			continue
		}

		if m[i] != nil {
			if err := m[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName(strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName(strconv.Itoa(i))
				}
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validate this c11y vector based question based on the context it is used
func (m C11yVectorBasedQuestion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	for i := 0; i < len(m); i++ {

		if m[i] != nil {
			if err := m[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName(strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName(strconv.Itoa(i))
				}
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// C11yVectorBasedQuestionItems0 c11y vector based question items0
//
// swagger:model C11yVectorBasedQuestionItems0
type C11yVectorBasedQuestionItems0 struct {

	// Vectorized properties.
	// Max Items: 300
	// Min Items: 300
	ClassProps []*C11yVectorBasedQuestionItems0ClassPropsItems0 `json:"classProps"`

	// Vectorized collection (class) name.
	// Max Items: 300
	// Min Items: 300
	ClassVectors []float32 `json:"classVectors"`
}

// Validate validates this c11y vector based question items0
func (m *C11yVectorBasedQuestionItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClassProps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClassVectors(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *C11yVectorBasedQuestionItems0) validateClassProps(formats strfmt.Registry) error {
	if swag.IsZero(m.ClassProps) { // not required
		return nil
	}

	iClassPropsSize := int64(len(m.ClassProps))

	if err := validate.MinItems("classProps", "body", iClassPropsSize, 300); err != nil {
		return err
	}

	if err := validate.MaxItems("classProps", "body", iClassPropsSize, 300); err != nil {
		return err
	}

	for i := 0; i < len(m.ClassProps); i++ {
		if swag.IsZero(m.ClassProps[i]) { // not required
			continue
		}

		if m.ClassProps[i] != nil {
			if err := m.ClassProps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("classProps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("classProps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *C11yVectorBasedQuestionItems0) validateClassVectors(formats strfmt.Registry) error {
	if swag.IsZero(m.ClassVectors) { // not required
		return nil
	}

	iClassVectorsSize := int64(len(m.ClassVectors))

	if err := validate.MinItems("classVectors", "body", iClassVectorsSize, 300); err != nil {
		return err
	}

	if err := validate.MaxItems("classVectors", "body", iClassVectorsSize, 300); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this c11y vector based question items0 based on the context it is used
func (m *C11yVectorBasedQuestionItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClassProps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *C11yVectorBasedQuestionItems0) contextValidateClassProps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ClassProps); i++ {

		if m.ClassProps[i] != nil {
			if err := m.ClassProps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("classProps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("classProps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *C11yVectorBasedQuestionItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *C11yVectorBasedQuestionItems0) UnmarshalBinary(b []byte) error {
	var res C11yVectorBasedQuestionItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// C11yVectorBasedQuestionItems0ClassPropsItems0 c11y vector based question items0 class props items0
//
// swagger:model C11yVectorBasedQuestionItems0ClassPropsItems0
type C11yVectorBasedQuestionItems0ClassPropsItems0 struct {

	// props vectors
	PropsVectors []float32 `json:"propsVectors"`

	// String with valuename.
	Value string `json:"value,omitempty"`
}

// Validate validates this c11y vector based question items0 class props items0
func (m *C11yVectorBasedQuestionItems0ClassPropsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this c11y vector based question items0 class props items0 based on context it is used
func (m *C11yVectorBasedQuestionItems0ClassPropsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *C11yVectorBasedQuestionItems0ClassPropsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *C11yVectorBasedQuestionItems0ClassPropsItems0) UnmarshalBinary(b []byte) error {
	var res C11yVectorBasedQuestionItems0ClassPropsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
