//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Classification Manage classifications, trigger them and view status of past classifications.
//
// swagger:model Classification
type Classification struct {

	// Base the text-based classification on these fields (of type text).
	// Example: ["description"]
	BasedOnProperties []string `json:"basedOnProperties"`

	// The name of the collection (class) which is used in this classification.
	// Example: City
	Class string `json:"class,omitempty"`

	// Which ref-property to set as part of the classification.
	// Example: ["inCountry"]
	ClassifyProperties []string `json:"classifyProperties"`

	// Error message if status == failed.
	// Example: classify xzy: something went wrong
	Error string `json:"error,omitempty"`

	// filters
	Filters *ClassificationFilters `json:"filters,omitempty"`

	// ID to uniquely identify this classification run.
	// Example: ee722219-b8ec-4db1-8f8d-5150bb1a9e0c
	// Format: uuid
	ID strfmt.UUID `json:"id,omitempty"`

	// Additional meta information about the classification.
	Meta *ClassificationMeta `json:"meta,omitempty"`

	// Classification-type specific settings.
	Settings interface{} `json:"settings,omitempty"`

	// Status of this classification.
	// Example: running
	// Enum: [running completed failed]
	Status string `json:"status,omitempty"`

	// Which algorithm to use for classifications.
	Type string `json:"type,omitempty"`
}

// Validate validates this classification
func (m *Classification) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFilters(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMeta(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Classification) validateFilters(formats strfmt.Registry) error {
	if swag.IsZero(m.Filters) { // not required
		return nil
	}

	if m.Filters != nil {
		if err := m.Filters.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filters")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filters")
			}
			return err
		}
	}

	return nil
}

func (m *Classification) validateID(formats strfmt.Registry) error {
	if swag.IsZero(m.ID) { // not required
		return nil
	}

	if err := validate.FormatOf("id", "body", "uuid", m.ID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Classification) validateMeta(formats strfmt.Registry) error {
	if swag.IsZero(m.Meta) { // not required
		return nil
	}

	if m.Meta != nil {
		if err := m.Meta.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("meta")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("meta")
			}
			return err
		}
	}

	return nil
}

var classificationTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["running","completed","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		classificationTypeStatusPropEnum = append(classificationTypeStatusPropEnum, v)
	}
}

const (

	// ClassificationStatusRunning captures enum value "running"
	ClassificationStatusRunning string = "running"

	// ClassificationStatusCompleted captures enum value "completed"
	ClassificationStatusCompleted string = "completed"

	// ClassificationStatusFailed captures enum value "failed"
	ClassificationStatusFailed string = "failed"
)

// prop value enum
func (m *Classification) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, classificationTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Classification) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this classification based on the context it is used
func (m *Classification) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFilters(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMeta(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Classification) contextValidateFilters(ctx context.Context, formats strfmt.Registry) error {

	if m.Filters != nil {
		if err := m.Filters.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filters")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filters")
			}
			return err
		}
	}

	return nil
}

func (m *Classification) contextValidateMeta(ctx context.Context, formats strfmt.Registry) error {

	if m.Meta != nil {
		if err := m.Meta.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("meta")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("meta")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Classification) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Classification) UnmarshalBinary(b []byte) error {
	var res Classification
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClassificationFilters classification filters
//
// swagger:model ClassificationFilters
type ClassificationFilters struct {

	// Limit the objects to be classified.
	SourceWhere *WhereFilter `json:"sourceWhere,omitempty"`

	// Limit the possible sources when using an algorithm which doesn't really on training data, e.g. 'contextual'. When using an algorithm with a training set, such as 'knn', limit the training set instead.
	TargetWhere *WhereFilter `json:"targetWhere,omitempty"`

	// Limit the training objects to be considered during the classification. Can only be used on types with explicit training sets, such as 'knn'.
	TrainingSetWhere *WhereFilter `json:"trainingSetWhere,omitempty"`
}

// Validate validates this classification filters
func (m *ClassificationFilters) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSourceWhere(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetWhere(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTrainingSetWhere(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClassificationFilters) validateSourceWhere(formats strfmt.Registry) error {
	if swag.IsZero(m.SourceWhere) { // not required
		return nil
	}

	if m.SourceWhere != nil {
		if err := m.SourceWhere.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filters" + "." + "sourceWhere")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filters" + "." + "sourceWhere")
			}
			return err
		}
	}

	return nil
}

func (m *ClassificationFilters) validateTargetWhere(formats strfmt.Registry) error {
	if swag.IsZero(m.TargetWhere) { // not required
		return nil
	}

	if m.TargetWhere != nil {
		if err := m.TargetWhere.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filters" + "." + "targetWhere")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filters" + "." + "targetWhere")
			}
			return err
		}
	}

	return nil
}

func (m *ClassificationFilters) validateTrainingSetWhere(formats strfmt.Registry) error {
	if swag.IsZero(m.TrainingSetWhere) { // not required
		return nil
	}

	if m.TrainingSetWhere != nil {
		if err := m.TrainingSetWhere.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filters" + "." + "trainingSetWhere")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filters" + "." + "trainingSetWhere")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this classification filters based on the context it is used
func (m *ClassificationFilters) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSourceWhere(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTargetWhere(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTrainingSetWhere(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClassificationFilters) contextValidateSourceWhere(ctx context.Context, formats strfmt.Registry) error {

	if m.SourceWhere != nil {
		if err := m.SourceWhere.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filters" + "." + "sourceWhere")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filters" + "." + "sourceWhere")
			}
			return err
		}
	}

	return nil
}

func (m *ClassificationFilters) contextValidateTargetWhere(ctx context.Context, formats strfmt.Registry) error {

	if m.TargetWhere != nil {
		if err := m.TargetWhere.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filters" + "." + "targetWhere")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filters" + "." + "targetWhere")
			}
			return err
		}
	}

	return nil
}

func (m *ClassificationFilters) contextValidateTrainingSetWhere(ctx context.Context, formats strfmt.Registry) error {

	if m.TrainingSetWhere != nil {
		if err := m.TrainingSetWhere.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filters" + "." + "trainingSetWhere")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filters" + "." + "trainingSetWhere")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClassificationFilters) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClassificationFilters) UnmarshalBinary(b []byte) error {
	var res ClassificationFilters
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
