//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClassificationMeta Additional information to a specific classification.
//
// swagger:model ClassificationMeta
type ClassificationMeta struct {

	// Time when this classification finished.
	// Example: 2017-07-21T17:32:28Z
	// Format: date-time
	Completed strfmt.DateTime `json:"completed,omitempty"`

	// Number of objects which were taken into consideration for classification.
	// Example: 147
	Count int64 `json:"count,omitempty"`

	// Number of objects which could not be classified - see error message for details.
	// Example: 7
	CountFailed int64 `json:"countFailed,omitempty"`

	// Number of objects successfully classified.
	// Example: 140
	CountSucceeded int64 `json:"countSucceeded,omitempty"`

	// Time when this classification was started.
	// Example: 2017-07-21T17:32:28Z
	// Format: date-time
	Started strfmt.DateTime `json:"started,omitempty"`
}

// Validate validates this classification meta
func (m *ClassificationMeta) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCompleted(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStarted(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClassificationMeta) validateCompleted(formats strfmt.Registry) error {
	if swag.IsZero(m.Completed) { // not required
		return nil
	}

	if err := validate.FormatOf("completed", "body", "date-time", m.Completed.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ClassificationMeta) validateStarted(formats strfmt.Registry) error {
	if swag.IsZero(m.Started) { // not required
		return nil
	}

	if err := validate.FormatOf("started", "body", "date-time", m.Started.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this classification meta based on context it is used
func (m *ClassificationMeta) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClassificationMeta) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClassificationMeta) UnmarshalBinary(b []byte) error {
	var res ClassificationMeta
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
