//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NodeShardStatus The definition of a node shard status response body
//
// swagger:model NodeShardStatus
type NodeShardStatus struct {

	// The status of the async replication.
	AsyncReplicationStatus []*AsyncReplicationStatus `json:"asyncReplicationStatus"`

	// The name of shard's collection (class).
	Class string `json:"class"`

	// The status of vector compression/quantization.
	Compressed bool `json:"compressed"`

	// The load status of the shard.
	Loaded bool `json:"loaded"`

	// The name of the shard.
	Name string `json:"name"`

	// Number of replicas for the shard.
	NumberOfReplicas int64 `json:"numberOfReplicas,omitempty"`

	// The number of objects in shard.
	ObjectCount int64 `json:"objectCount"`

	// Minimum number of replicas for the shard.
	ReplicationFactor int64 `json:"replicationFactor,omitempty"`

	// The status of the vector indexing process.
	VectorIndexingStatus string `json:"vectorIndexingStatus"`

	// The length of the vector indexing queue.
	VectorQueueLength int64 `json:"vectorQueueLength"`
}

// Validate validates this node shard status
func (m *NodeShardStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAsyncReplicationStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeShardStatus) validateAsyncReplicationStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.AsyncReplicationStatus) { // not required
		return nil
	}

	for i := 0; i < len(m.AsyncReplicationStatus); i++ {
		if swag.IsZero(m.AsyncReplicationStatus[i]) { // not required
			continue
		}

		if m.AsyncReplicationStatus[i] != nil {
			if err := m.AsyncReplicationStatus[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("asyncReplicationStatus" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("asyncReplicationStatus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this node shard status based on the context it is used
func (m *NodeShardStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAsyncReplicationStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeShardStatus) contextValidateAsyncReplicationStatus(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AsyncReplicationStatus); i++ {

		if m.AsyncReplicationStatus[i] != nil {
			if err := m.AsyncReplicationStatus[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("asyncReplicationStatus" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("asyncReplicationStatus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeShardStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeShardStatus) UnmarshalBinary(b []byte) error {
	var res NodeShardStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
