//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ObjectTTLConfig Configuration of objects' time-to-live
//
// swagger:model ObjectTtlConfig
type ObjectTTLConfig struct {

	// Interval (in seconds) to be added to `deleteOn` value, denoting object's expiration time. Has to be positive for `deleteOn` set to `_creationTimeUnix` or `_lastUpdateTimeUnix`, any for custom property (default: `0`).
	DefaultTTL int64 `json:"defaultTtl"`

	// Name of the property holding base time to compute object's expiration time (ttl = value of deleteOn property + defaultTtl). Can be set to `_creationTimeUnix`, `_lastUpdateTimeUnix` or custom property of `date` datatype.
	DeleteOn string `json:"deleteOn"`

	// Whether or not object ttl is enabled for this collection (default: `false`).
	Enabled bool `json:"enabled"`

	// Whether remove from resultset expired, but not yet deleted by background process objects (default: `false`).
	FilterExpiredObjects bool `json:"filterExpiredObjects"`
}

// Validate validates this object Ttl config
func (m *ObjectTTLConfig) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this object Ttl config based on context it is used
func (m *ObjectTTLConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ObjectTTLConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ObjectTTLConfig) UnmarshalBinary(b []byte) error {
	var res ObjectTTLConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
