//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ReplicationReplicateDetailsReplicaResponse Provides a comprehensive overview of a specific replication operation, detailing its unique ID, the involved collection, shard, source and target nodes, transfer type, current status, and optionally, its status history.
//
// swagger:model ReplicationReplicateDetailsReplicaResponse
type ReplicationReplicateDetailsReplicaResponse struct {

	// The name of the collection to which the shard being replicated belongs.
	// Required: true
	Collection *string `json:"collection"`

	// The unique identifier (ID) of this specific replication operation.
	// Required: true
	// Format: uuid
	ID *strfmt.UUID `json:"id"`

	// Whether the replica operation is scheduled for cancellation.
	ScheduledForCancel bool `json:"scheduledForCancel,omitempty"`

	// Whether the replica operation is scheduled for deletion.
	ScheduledForDelete bool `json:"scheduledForDelete,omitempty"`

	// The name of the shard involved in this replication operation.
	// Required: true
	Shard *string `json:"shard"`

	// The identifier of the node from which the replica is being moved or copied (the source node).
	// Required: true
	SourceNode *string `json:"sourceNode"`

	// An object detailing the current operational state of the replica movement and any errors encountered.
	// Required: true
	Status *ReplicationReplicateDetailsReplicaStatus `json:"status"`

	// An array detailing the historical sequence of statuses the replication operation has transitioned through, if requested and available.
	StatusHistory []*ReplicationReplicateDetailsReplicaStatus `json:"statusHistory"`

	// The identifier of the node to which the replica is being moved or copied (the target node).
	// Required: true
	TargetNode *string `json:"targetNode"`

	// Indicates whether the operation is a `COPY` (source replica remains) or a `MOVE` (source replica is removed after successful transfer).
	// Required: true
	// Enum: [COPY MOVE]
	Type *string `json:"type"`

	// Whether the replica operation can't be cancelled.
	Uncancelable bool `json:"uncancelable,omitempty"`

	// The UNIX timestamp in ms when the replication operation was initiated. This is an approximate time and so should not be used for precise timing.
	WhenStartedUnixMs int64 `json:"whenStartedUnixMs,omitempty"`
}

// Validate validates this replication replicate details replica response
func (m *ReplicationReplicateDetailsReplicaResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCollection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShard(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSourceNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatusHistory(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationReplicateDetailsReplicaResponse) validateCollection(formats strfmt.Registry) error {

	if err := validate.Required("collection", "body", m.Collection); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationReplicateDetailsReplicaResponse) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	if err := validate.FormatOf("id", "body", "uuid", m.ID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationReplicateDetailsReplicaResponse) validateShard(formats strfmt.Registry) error {

	if err := validate.Required("shard", "body", m.Shard); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationReplicateDetailsReplicaResponse) validateSourceNode(formats strfmt.Registry) error {

	if err := validate.Required("sourceNode", "body", m.SourceNode); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationReplicateDetailsReplicaResponse) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *ReplicationReplicateDetailsReplicaResponse) validateStatusHistory(formats strfmt.Registry) error {
	if swag.IsZero(m.StatusHistory) { // not required
		return nil
	}

	for i := 0; i < len(m.StatusHistory); i++ {
		if swag.IsZero(m.StatusHistory[i]) { // not required
			continue
		}

		if m.StatusHistory[i] != nil {
			if err := m.StatusHistory[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("statusHistory" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("statusHistory" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ReplicationReplicateDetailsReplicaResponse) validateTargetNode(formats strfmt.Registry) error {

	if err := validate.Required("targetNode", "body", m.TargetNode); err != nil {
		return err
	}

	return nil
}

var replicationReplicateDetailsReplicaResponseTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["COPY","MOVE"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		replicationReplicateDetailsReplicaResponseTypeTypePropEnum = append(replicationReplicateDetailsReplicaResponseTypeTypePropEnum, v)
	}
}

const (

	// ReplicationReplicateDetailsReplicaResponseTypeCOPY captures enum value "COPY"
	ReplicationReplicateDetailsReplicaResponseTypeCOPY string = "COPY"

	// ReplicationReplicateDetailsReplicaResponseTypeMOVE captures enum value "MOVE"
	ReplicationReplicateDetailsReplicaResponseTypeMOVE string = "MOVE"
)

// prop value enum
func (m *ReplicationReplicateDetailsReplicaResponse) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, replicationReplicateDetailsReplicaResponseTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ReplicationReplicateDetailsReplicaResponse) validateType(formats strfmt.Registry) error {

	if err := validate.Required("type", "body", m.Type); err != nil {
		return err
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this replication replicate details replica response based on the context it is used
func (m *ReplicationReplicateDetailsReplicaResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatusHistory(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationReplicateDetailsReplicaResponse) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *ReplicationReplicateDetailsReplicaResponse) contextValidateStatusHistory(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StatusHistory); i++ {

		if m.StatusHistory[i] != nil {
			if err := m.StatusHistory[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("statusHistory" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("statusHistory" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ReplicationReplicateDetailsReplicaResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReplicationReplicateDetailsReplicaResponse) UnmarshalBinary(b []byte) error {
	var res ReplicationReplicateDetailsReplicaResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
