//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ReplicationReplicateForceDeleteResponse Provides the UUIDs that were successfully force deleted as part of the replication operation. If dryRun is true, this will return the expected outcome without actually deleting anything.
//
// swagger:model ReplicationReplicateForceDeleteResponse
type ReplicationReplicateForceDeleteResponse struct {

	// The unique identifiers (IDs) of the replication operations that were forcefully deleted.
	Deleted []strfmt.UUID `json:"deleted"`

	// Indicates whether the operation was a dry run (true) or an actual deletion (false).
	DryRun bool `json:"dryRun,omitempty"`
}

// Validate validates this replication replicate force delete response
func (m *ReplicationReplicateForceDeleteResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDeleted(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationReplicateForceDeleteResponse) validateDeleted(formats strfmt.Registry) error {
	if swag.IsZero(m.Deleted) { // not required
		return nil
	}

	for i := 0; i < len(m.Deleted); i++ {

		if err := validate.FormatOf("deleted"+"."+strconv.Itoa(i), "body", "uuid", m.Deleted[i].String(), formats); err != nil {
			return err
		}

	}

	return nil
}

// ContextValidate validates this replication replicate force delete response based on context it is used
func (m *ReplicationReplicateForceDeleteResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ReplicationReplicateForceDeleteResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReplicationReplicateForceDeleteResponse) UnmarshalBinary(b []byte) error {
	var res ReplicationReplicateForceDeleteResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
