//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ReplicationScalePlan Defines a complete plan for scaling replication within a collection. Each shard entry specifies nodes to remove and nodes to add. Added nodes may either be initialized empty (null) or created by replicating data from a source node specified as a string. If a source node is also marked for removal in the same shard, it represents a move operation and can only be used once as a source for that shard. If a source node is not marked for removal, it represents a copy operation and can be used as the source for multiple additions in that shard. Nodes listed in 'removeNodes' cannot also appear as targets in 'addNodes' for the same shard, and the same node cannot be specified for both addition and removal in a single shard.
//
// swagger:model ReplicationScalePlan
type ReplicationScalePlan struct {

	// The name of the collection to which this replication scaling plan applies.
	// Required: true
	Collection string `json:"collection"`

	// A unique identifier for this replication scaling plan, useful for tracking and auditing purposes.
	// Required: true
	// Format: uuid
	PlanID strfmt.UUID `json:"planId"`

	// A mapping of shard names to their corresponding scaling actions. Each key corresponds to a shard name, and its value defines which nodes should be removed and which should be added for that shard. If a source node listed for an addition is also in 'removeNodes' for the same shard, that addition is treated as a move operation. Such a node can appear only once as a source in that shard. Otherwise, if the source node is not being removed, it represents a copy operation and can be referenced multiple times as a source for additions.
	// Required: true
	ShardScaleActions map[string]ReplicationScalePlanShardScaleActionsAnon `json:"shardScaleActions"`
}

// Validate validates this replication scale plan
func (m *ReplicationScalePlan) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCollection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlanID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShardScaleActions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationScalePlan) validateCollection(formats strfmt.Registry) error {

	if err := validate.RequiredString("collection", "body", m.Collection); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationScalePlan) validatePlanID(formats strfmt.Registry) error {

	if err := validate.Required("planId", "body", strfmt.UUID(m.PlanID)); err != nil {
		return err
	}

	if err := validate.FormatOf("planId", "body", "uuid", m.PlanID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ReplicationScalePlan) validateShardScaleActions(formats strfmt.Registry) error {

	if err := validate.Required("shardScaleActions", "body", m.ShardScaleActions); err != nil {
		return err
	}

	for k := range m.ShardScaleActions {

		if err := validate.Required("shardScaleActions"+"."+k, "body", m.ShardScaleActions[k]); err != nil {
			return err
		}
		if val, ok := m.ShardScaleActions[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("shardScaleActions" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("shardScaleActions" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this replication scale plan based on the context it is used
func (m *ReplicationScalePlan) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateShardScaleActions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReplicationScalePlan) contextValidateShardScaleActions(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.Required("shardScaleActions", "body", m.ShardScaleActions); err != nil {
		return err
	}

	for k := range m.ShardScaleActions {

		if val, ok := m.ShardScaleActions[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ReplicationScalePlan) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReplicationScalePlan) UnmarshalBinary(b []byte) error {
	var res ReplicationScalePlan
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ReplicationScalePlanShardScaleActionsAnon Scaling actions for a single shard, including which nodes to remove and which to add. Nodes listed in 'removeNodes' cannot appear as targets in 'addNodes' for the same shard. If a source node is also marked for removal, it is treated as a move operation and can only appear once as a source node in that shard. A source node that is not being removed can appear multiple times as a source node for additions in that shard (copy operations).
//
// swagger:model ReplicationScalePlanShardScaleActionsAnon
type ReplicationScalePlanShardScaleActionsAnon struct {

	// A mapping of target node identifiers to their addition configuration. Each key represents a target node where a new replica will be added. The value may be null, which means an empty replica will be created, or a string specifying the source node from which shard data will be copied. If the source node is also marked for removal in the same shard, this addition is treated as a move operation, and that source node can only appear once as a source node for that shard. If the source node is not being removed, it can be used as the source for multiple additions (copy operations).
	AddNodes map[string]string `json:"addNodes,omitempty"`

	// List of node identifiers from which replicas of this shard should be removed. Nodes listed here must not appear in 'addNodes' for the same shard, and cannot be used as a source node for any addition in this shard except in the implicit move case, where they appear as both a source and a node to remove.
	RemoveNodes []string `json:"removeNodes"`
}

// Validate validates this replication scale plan shard scale actions anon
func (m *ReplicationScalePlanShardScaleActionsAnon) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this replication scale plan shard scale actions anon based on context it is used
func (m *ReplicationScalePlanShardScaleActionsAnon) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ReplicationScalePlanShardScaleActionsAnon) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReplicationScalePlanShardScaleActionsAnon) UnmarshalBinary(b []byte) error {
	var res ReplicationScalePlanShardScaleActionsAnon
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
