//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// UserTypeInput The type of the user. `db` users are managed by Weaviate, `oidc` users are managed by an external OIDC provider.
//
// swagger:model UserTypeInput
type UserTypeInput string

func NewUserTypeInput(value UserTypeInput) *UserTypeInput {
	return &value
}

// Pointer returns a pointer to a freshly-allocated UserTypeInput.
func (m UserTypeInput) Pointer() *UserTypeInput {
	return &m
}

const (

	// UserTypeInputDb captures enum value "db"
	UserTypeInputDb UserTypeInput = "db"

	// UserTypeInputOidc captures enum value "oidc"
	UserTypeInputOidc UserTypeInput = "oidc"
)

// for schema
var userTypeInputEnum []interface{}

func init() {
	var res []UserTypeInput
	if err := json.Unmarshal([]byte(`["db","oidc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		userTypeInputEnum = append(userTypeInputEnum, v)
	}
}

func (m UserTypeInput) validateUserTypeInputEnum(path, location string, value UserTypeInput) error {
	if err := validate.EnumCase(path, location, value, userTypeInputEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this user type input
func (m UserTypeInput) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateUserTypeInputEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this user type input based on context it is used
func (m UserTypeInput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
