//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"

	"github.com/go-openapi/strfmt"
)

// Vectors A map of named vectors for multi-vector representations.
//
// swagger:model Vectors
type Vectors map[string]Vector

// Validate validates this vectors
func (m Vectors) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this vectors based on context it is used
func (m Vectors) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// UnmarshalJSON custom unmarshalling method
func (v *Vectors) UnmarshalJSON(data []byte) error {
	var rawVectors map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawVectors); err != nil {
		return err
	}

	if len(rawVectors) > 0 {
		*v = make(Vectors)
		for targetVector, rawMessage := range rawVectors {
			// Try unmarshaling as []float32
			var vector []float32
			if err := json.Unmarshal(rawMessage, &vector); err == nil {
				if len(vector) > 0 {
					(*v)[targetVector] = vector
				}
				continue
			}
			// Try unmarshaling as [][]float32
			var multiVector [][]float32
			if err := json.Unmarshal(rawMessage, &multiVector); err == nil {
				if len(multiVector) > 0 {
					(*v)[targetVector] = multiVector
				}
				continue
			}
			return fmt.Errorf("vectors: cannot unmarshal vector into either []float32 or [][]float32 for target vector %s", targetVector)
		}
	}
	return nil
}
