// Copyright 2015, Google Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// This is a copy of the google health check file with changed namespace. This enables our clients to use the health
// check without having to import google's proto files which might have dependency conflicts.
//
// This file should NOT be used to start our own health check server in Weaviate itself, but only for clients to
// generate their protobufs and grpc code from it.
//
// See: https://github.com/weaviate/weaviate-python-client/issues/1807 and
//      https://github.com/weaviate/weaviate-python-client/issues/1786
//

// Code generated by protoc-gen-go. DO NOT EDIT.

package protocol

import (
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type WeaviateHealthCheckResponse_ServingStatus int32

const (
	WeaviateHealthCheckResponse_UNKNOWN     WeaviateHealthCheckResponse_ServingStatus = 0
	WeaviateHealthCheckResponse_SERVING     WeaviateHealthCheckResponse_ServingStatus = 1
	WeaviateHealthCheckResponse_NOT_SERVING WeaviateHealthCheckResponse_ServingStatus = 2
)

// Enum value maps for WeaviateHealthCheckResponse_ServingStatus.
var (
	WeaviateHealthCheckResponse_ServingStatus_name = map[int32]string{
		0: "UNKNOWN",
		1: "SERVING",
		2: "NOT_SERVING",
	}
	WeaviateHealthCheckResponse_ServingStatus_value = map[string]int32{
		"UNKNOWN":     0,
		"SERVING":     1,
		"NOT_SERVING": 2,
	}
)

func (x WeaviateHealthCheckResponse_ServingStatus) Enum() *WeaviateHealthCheckResponse_ServingStatus {
	p := new(WeaviateHealthCheckResponse_ServingStatus)
	*p = x
	return p
}

func (x WeaviateHealthCheckResponse_ServingStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WeaviateHealthCheckResponse_ServingStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_v1_health_weaviate_proto_enumTypes[0].Descriptor()
}

func (WeaviateHealthCheckResponse_ServingStatus) Type() protoreflect.EnumType {
	return &file_v1_health_weaviate_proto_enumTypes[0]
}

func (x WeaviateHealthCheckResponse_ServingStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WeaviateHealthCheckResponse_ServingStatus.Descriptor instead.
func (WeaviateHealthCheckResponse_ServingStatus) EnumDescriptor() ([]byte, []int) {
	return file_v1_health_weaviate_proto_rawDescGZIP(), []int{1, 0}
}

type WeaviateHealthCheckRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Service       string                 `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WeaviateHealthCheckRequest) Reset() {
	*x = WeaviateHealthCheckRequest{}
	mi := &file_v1_health_weaviate_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WeaviateHealthCheckRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WeaviateHealthCheckRequest) ProtoMessage() {}

func (x *WeaviateHealthCheckRequest) ProtoReflect() protoreflect.Message {
	mi := &file_v1_health_weaviate_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WeaviateHealthCheckRequest.ProtoReflect.Descriptor instead.
func (*WeaviateHealthCheckRequest) Descriptor() ([]byte, []int) {
	return file_v1_health_weaviate_proto_rawDescGZIP(), []int{0}
}

func (x *WeaviateHealthCheckRequest) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

type WeaviateHealthCheckResponse struct {
	state         protoimpl.MessageState                    `protogen:"open.v1"`
	Status        WeaviateHealthCheckResponse_ServingStatus `protobuf:"varint,1,opt,name=status,proto3,enum=weaviate.v1.WeaviateHealthCheckResponse_ServingStatus" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WeaviateHealthCheckResponse) Reset() {
	*x = WeaviateHealthCheckResponse{}
	mi := &file_v1_health_weaviate_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WeaviateHealthCheckResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WeaviateHealthCheckResponse) ProtoMessage() {}

func (x *WeaviateHealthCheckResponse) ProtoReflect() protoreflect.Message {
	mi := &file_v1_health_weaviate_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WeaviateHealthCheckResponse.ProtoReflect.Descriptor instead.
func (*WeaviateHealthCheckResponse) Descriptor() ([]byte, []int) {
	return file_v1_health_weaviate_proto_rawDescGZIP(), []int{1}
}

func (x *WeaviateHealthCheckResponse) GetStatus() WeaviateHealthCheckResponse_ServingStatus {
	if x != nil {
		return x.Status
	}
	return WeaviateHealthCheckResponse_UNKNOWN
}

var File_v1_health_weaviate_proto protoreflect.FileDescriptor

const file_v1_health_weaviate_proto_rawDesc = "" +
	"\n" +
	"\x18v1/health_weaviate.proto\x12\vweaviate.v1\"6\n" +
	"\x1aWeaviateHealthCheckRequest\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\"\xa9\x01\n" +
	"\x1bWeaviateHealthCheckResponse\x12N\n" +
	"\x06status\x18\x01 \x01(\x0e26.weaviate.v1.WeaviateHealthCheckResponse.ServingStatusR\x06status\":\n" +
	"\rServingStatus\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\v\n" +
	"\aSERVING\x10\x01\x12\x0f\n" +
	"\vNOT_SERVING\x10\x02Bk\n" +
	"#io.weaviate.client.grpc.protocol.v1B\x0eWeaviateHealthZ4github.com/weaviate/weaviate/grpc/generated;protocolb\x06proto3"

var (
	file_v1_health_weaviate_proto_rawDescOnce sync.Once
	file_v1_health_weaviate_proto_rawDescData []byte
)

func file_v1_health_weaviate_proto_rawDescGZIP() []byte {
	file_v1_health_weaviate_proto_rawDescOnce.Do(func() {
		file_v1_health_weaviate_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_v1_health_weaviate_proto_rawDesc), len(file_v1_health_weaviate_proto_rawDesc)))
	})
	return file_v1_health_weaviate_proto_rawDescData
}

var file_v1_health_weaviate_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_v1_health_weaviate_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_v1_health_weaviate_proto_goTypes = []any{
	(WeaviateHealthCheckResponse_ServingStatus)(0), // 0: weaviate.v1.WeaviateHealthCheckResponse.ServingStatus
	(*WeaviateHealthCheckRequest)(nil),             // 1: weaviate.v1.WeaviateHealthCheckRequest
	(*WeaviateHealthCheckResponse)(nil),            // 2: weaviate.v1.WeaviateHealthCheckResponse
}
var file_v1_health_weaviate_proto_depIdxs = []int32{
	0, // 0: weaviate.v1.WeaviateHealthCheckResponse.status:type_name -> weaviate.v1.WeaviateHealthCheckResponse.ServingStatus
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_v1_health_weaviate_proto_init() }
func file_v1_health_weaviate_proto_init() {
	if File_v1_health_weaviate_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_v1_health_weaviate_proto_rawDesc), len(file_v1_health_weaviate_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_v1_health_weaviate_proto_goTypes,
		DependencyIndexes: file_v1_health_weaviate_proto_depIdxs,
		EnumInfos:         file_v1_health_weaviate_proto_enumTypes,
		MessageInfos:      file_v1_health_weaviate_proto_msgTypes,
	}.Build()
	File_v1_health_weaviate_proto = out.File
	file_v1_health_weaviate_proto_goTypes = nil
	file_v1_health_weaviate_proto_depIdxs = nil
}
