//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

package nearDepth

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/tailor-platform/graphql"
)

func TestNearDepthGraphQLArgument(t *testing.T) {
	t.Run("should generate nearDepth argument properly", func(t *testing.T) {
		// given
		prefix := "Prefix"
		classname := "Class"
		// when
		nearDepth := nearDepthArgument(prefix, classname)

		// then
		// the built graphQL field needs to support this structure:
		// nearDepth: {
		//   depth: "base64;encoded,depth_depth",
		//   distance: 0.9
		//   targetVectors: ["targetVector"]
		// }
		assert.NotNil(t, nearDepth)
		assert.Equal(t, "Multi2VecBindPrefixClassNearDepthInpObj", nearDepth.Type.Name())
		answerFields, ok := nearDepth.Type.(*graphql.InputObject)
		assert.True(t, ok)
		assert.NotNil(t, answerFields)
		assert.Equal(t, 4, len(answerFields.Fields()))
		fields := answerFields.Fields()
		depth := fields["depth"]
		depthNonNull, depthNonNullOK := depth.Type.(*graphql.NonNull)
		assert.True(t, depthNonNullOK)
		assert.Equal(t, "String", depthNonNull.OfType.Name())
		assert.NotNil(t, depth)
		assert.NotNil(t, fields["certainty"])
		assert.NotNil(t, fields["distance"])
		targetVectors := fields["targetVectors"]
		targetVectorsList, targetVectorsListOK := targetVectors.Type.(*graphql.List)
		assert.True(t, targetVectorsListOK)
		assert.Equal(t, "String", targetVectorsList.OfType.Name())
		assert.NotNil(t, targetVectors)
	})
}
