//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by mockery v2.53.5. DO NOT EDIT.

package schema

import (
	context "context"

	clusterschema "github.com/weaviate/weaviate/cluster/schema"

	mock "github.com/stretchr/testify/mock"

	models "github.com/weaviate/weaviate/entities/models"

	sharding "github.com/weaviate/weaviate/usecases/sharding"

	versioned "github.com/weaviate/weaviate/entities/versioned"
)

// MockSchemaReader is an autogenerated mock type for the SchemaReader type
type MockSchemaReader struct {
	mock.Mock
}

type MockSchemaReader_Expecter struct {
	mock *mock.Mock
}

func (_m *MockSchemaReader) EXPECT() *MockSchemaReader_Expecter {
	return &MockSchemaReader_Expecter{mock: &_m.Mock}
}

// Aliases provides a mock function with no fields
func (_m *MockSchemaReader) Aliases() map[string]string {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for Aliases")
	}

	var r0 map[string]string
	if rf, ok := ret.Get(0).(func() map[string]string); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]string)
		}
	}

	return r0
}

// MockSchemaReader_Aliases_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Aliases'
type MockSchemaReader_Aliases_Call struct {
	*mock.Call
}

// Aliases is a helper method to define mock.On call
func (_e *MockSchemaReader_Expecter) Aliases() *MockSchemaReader_Aliases_Call {
	return &MockSchemaReader_Aliases_Call{Call: _e.mock.On("Aliases")}
}

func (_c *MockSchemaReader_Aliases_Call) Run(run func()) *MockSchemaReader_Aliases_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockSchemaReader_Aliases_Call) Return(_a0 map[string]string) *MockSchemaReader_Aliases_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_Aliases_Call) RunAndReturn(run func() map[string]string) *MockSchemaReader_Aliases_Call {
	_c.Call.Return(run)
	return _c
}

// ClassEqual provides a mock function with given fields: name
func (_m *MockSchemaReader) ClassEqual(name string) string {
	ret := _m.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for ClassEqual")
	}

	var r0 string
	if rf, ok := ret.Get(0).(func(string) string); ok {
		r0 = rf(name)
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// MockSchemaReader_ClassEqual_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ClassEqual'
type MockSchemaReader_ClassEqual_Call struct {
	*mock.Call
}

// ClassEqual is a helper method to define mock.On call
//   - name string
func (_e *MockSchemaReader_Expecter) ClassEqual(name interface{}) *MockSchemaReader_ClassEqual_Call {
	return &MockSchemaReader_ClassEqual_Call{Call: _e.mock.On("ClassEqual", name)}
}

func (_c *MockSchemaReader_ClassEqual_Call) Run(run func(name string)) *MockSchemaReader_ClassEqual_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockSchemaReader_ClassEqual_Call) Return(_a0 string) *MockSchemaReader_ClassEqual_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_ClassEqual_Call) RunAndReturn(run func(string) string) *MockSchemaReader_ClassEqual_Call {
	_c.Call.Return(run)
	return _c
}

// ClassInfo provides a mock function with given fields: class
func (_m *MockSchemaReader) ClassInfo(class string) clusterschema.ClassInfo {
	ret := _m.Called(class)

	if len(ret) == 0 {
		panic("no return value specified for ClassInfo")
	}

	var r0 clusterschema.ClassInfo
	if rf, ok := ret.Get(0).(func(string) clusterschema.ClassInfo); ok {
		r0 = rf(class)
	} else {
		r0 = ret.Get(0).(clusterschema.ClassInfo)
	}

	return r0
}

// MockSchemaReader_ClassInfo_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ClassInfo'
type MockSchemaReader_ClassInfo_Call struct {
	*mock.Call
}

// ClassInfo is a helper method to define mock.On call
//   - class string
func (_e *MockSchemaReader_Expecter) ClassInfo(class interface{}) *MockSchemaReader_ClassInfo_Call {
	return &MockSchemaReader_ClassInfo_Call{Call: _e.mock.On("ClassInfo", class)}
}

func (_c *MockSchemaReader_ClassInfo_Call) Run(run func(class string)) *MockSchemaReader_ClassInfo_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockSchemaReader_ClassInfo_Call) Return(ci clusterschema.ClassInfo) *MockSchemaReader_ClassInfo_Call {
	_c.Call.Return(ci)
	return _c
}

func (_c *MockSchemaReader_ClassInfo_Call) RunAndReturn(run func(string) clusterschema.ClassInfo) *MockSchemaReader_ClassInfo_Call {
	_c.Call.Return(run)
	return _c
}

// ClassInfoWithVersion provides a mock function with given fields: ctx, class, version
func (_m *MockSchemaReader) ClassInfoWithVersion(ctx context.Context, class string, version uint64) (clusterschema.ClassInfo, error) {
	ret := _m.Called(ctx, class, version)

	if len(ret) == 0 {
		panic("no return value specified for ClassInfoWithVersion")
	}

	var r0 clusterschema.ClassInfo
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, uint64) (clusterschema.ClassInfo, error)); ok {
		return rf(ctx, class, version)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, uint64) clusterschema.ClassInfo); ok {
		r0 = rf(ctx, class, version)
	} else {
		r0 = ret.Get(0).(clusterschema.ClassInfo)
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, uint64) error); ok {
		r1 = rf(ctx, class, version)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_ClassInfoWithVersion_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ClassInfoWithVersion'
type MockSchemaReader_ClassInfoWithVersion_Call struct {
	*mock.Call
}

// ClassInfoWithVersion is a helper method to define mock.On call
//   - ctx context.Context
//   - class string
//   - version uint64
func (_e *MockSchemaReader_Expecter) ClassInfoWithVersion(ctx interface{}, class interface{}, version interface{}) *MockSchemaReader_ClassInfoWithVersion_Call {
	return &MockSchemaReader_ClassInfoWithVersion_Call{Call: _e.mock.On("ClassInfoWithVersion", ctx, class, version)}
}

func (_c *MockSchemaReader_ClassInfoWithVersion_Call) Run(run func(ctx context.Context, class string, version uint64)) *MockSchemaReader_ClassInfoWithVersion_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(string), args[2].(uint64))
	})
	return _c
}

func (_c *MockSchemaReader_ClassInfoWithVersion_Call) Return(_a0 clusterschema.ClassInfo, _a1 error) *MockSchemaReader_ClassInfoWithVersion_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_ClassInfoWithVersion_Call) RunAndReturn(run func(context.Context, string, uint64) (clusterschema.ClassInfo, error)) *MockSchemaReader_ClassInfoWithVersion_Call {
	_c.Call.Return(run)
	return _c
}

// GetAliasesForClass provides a mock function with given fields: class
func (_m *MockSchemaReader) GetAliasesForClass(class string) []*models.Alias {
	ret := _m.Called(class)

	if len(ret) == 0 {
		panic("no return value specified for GetAliasesForClass")
	}

	var r0 []*models.Alias
	if rf, ok := ret.Get(0).(func(string) []*models.Alias); ok {
		r0 = rf(class)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*models.Alias)
		}
	}

	return r0
}

// MockSchemaReader_GetAliasesForClass_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetAliasesForClass'
type MockSchemaReader_GetAliasesForClass_Call struct {
	*mock.Call
}

// GetAliasesForClass is a helper method to define mock.On call
//   - class string
func (_e *MockSchemaReader_Expecter) GetAliasesForClass(class interface{}) *MockSchemaReader_GetAliasesForClass_Call {
	return &MockSchemaReader_GetAliasesForClass_Call{Call: _e.mock.On("GetAliasesForClass", class)}
}

func (_c *MockSchemaReader_GetAliasesForClass_Call) Run(run func(class string)) *MockSchemaReader_GetAliasesForClass_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockSchemaReader_GetAliasesForClass_Call) Return(_a0 []*models.Alias) *MockSchemaReader_GetAliasesForClass_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_GetAliasesForClass_Call) RunAndReturn(run func(string) []*models.Alias) *MockSchemaReader_GetAliasesForClass_Call {
	_c.Call.Return(run)
	return _c
}

// GetShardsStatus provides a mock function with given fields: class, tenant
func (_m *MockSchemaReader) GetShardsStatus(class string, tenant string) (models.ShardStatusList, error) {
	ret := _m.Called(class, tenant)

	if len(ret) == 0 {
		panic("no return value specified for GetShardsStatus")
	}

	var r0 models.ShardStatusList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (models.ShardStatusList, error)); ok {
		return rf(class, tenant)
	}
	if rf, ok := ret.Get(0).(func(string, string) models.ShardStatusList); ok {
		r0 = rf(class, tenant)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(models.ShardStatusList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(class, tenant)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_GetShardsStatus_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetShardsStatus'
type MockSchemaReader_GetShardsStatus_Call struct {
	*mock.Call
}

// GetShardsStatus is a helper method to define mock.On call
//   - class string
//   - tenant string
func (_e *MockSchemaReader_Expecter) GetShardsStatus(class interface{}, tenant interface{}) *MockSchemaReader_GetShardsStatus_Call {
	return &MockSchemaReader_GetShardsStatus_Call{Call: _e.mock.On("GetShardsStatus", class, tenant)}
}

func (_c *MockSchemaReader_GetShardsStatus_Call) Run(run func(class string, tenant string)) *MockSchemaReader_GetShardsStatus_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].(string))
	})
	return _c
}

func (_c *MockSchemaReader_GetShardsStatus_Call) Return(_a0 models.ShardStatusList, _a1 error) *MockSchemaReader_GetShardsStatus_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_GetShardsStatus_Call) RunAndReturn(run func(string, string) (models.ShardStatusList, error)) *MockSchemaReader_GetShardsStatus_Call {
	_c.Call.Return(run)
	return _c
}

// LocalShards provides a mock function with given fields: class
func (_m *MockSchemaReader) LocalShards(class string) ([]string, error) {
	ret := _m.Called(class)

	if len(ret) == 0 {
		panic("no return value specified for LocalShards")
	}

	var r0 []string
	var r1 error
	if rf, ok := ret.Get(0).(func(string) ([]string, error)); ok {
		return rf(class)
	}
	if rf, ok := ret.Get(0).(func(string) []string); ok {
		r0 = rf(class)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(class)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_LocalShards_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'LocalShards'
type MockSchemaReader_LocalShards_Call struct {
	*mock.Call
}

// LocalShards is a helper method to define mock.On call
//   - class string
func (_e *MockSchemaReader_Expecter) LocalShards(class interface{}) *MockSchemaReader_LocalShards_Call {
	return &MockSchemaReader_LocalShards_Call{Call: _e.mock.On("LocalShards", class)}
}

func (_c *MockSchemaReader_LocalShards_Call) Run(run func(class string)) *MockSchemaReader_LocalShards_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockSchemaReader_LocalShards_Call) Return(_a0 []string, _a1 error) *MockSchemaReader_LocalShards_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_LocalShards_Call) RunAndReturn(run func(string) ([]string, error)) *MockSchemaReader_LocalShards_Call {
	_c.Call.Return(run)
	return _c
}

// MultiTenancy provides a mock function with given fields: class
func (_m *MockSchemaReader) MultiTenancy(class string) models.MultiTenancyConfig {
	ret := _m.Called(class)

	if len(ret) == 0 {
		panic("no return value specified for MultiTenancy")
	}

	var r0 models.MultiTenancyConfig
	if rf, ok := ret.Get(0).(func(string) models.MultiTenancyConfig); ok {
		r0 = rf(class)
	} else {
		r0 = ret.Get(0).(models.MultiTenancyConfig)
	}

	return r0
}

// MockSchemaReader_MultiTenancy_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'MultiTenancy'
type MockSchemaReader_MultiTenancy_Call struct {
	*mock.Call
}

// MultiTenancy is a helper method to define mock.On call
//   - class string
func (_e *MockSchemaReader_Expecter) MultiTenancy(class interface{}) *MockSchemaReader_MultiTenancy_Call {
	return &MockSchemaReader_MultiTenancy_Call{Call: _e.mock.On("MultiTenancy", class)}
}

func (_c *MockSchemaReader_MultiTenancy_Call) Run(run func(class string)) *MockSchemaReader_MultiTenancy_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockSchemaReader_MultiTenancy_Call) Return(_a0 models.MultiTenancyConfig) *MockSchemaReader_MultiTenancy_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_MultiTenancy_Call) RunAndReturn(run func(string) models.MultiTenancyConfig) *MockSchemaReader_MultiTenancy_Call {
	_c.Call.Return(run)
	return _c
}

// MultiTenancyWithVersion provides a mock function with given fields: ctx, class, version
func (_m *MockSchemaReader) MultiTenancyWithVersion(ctx context.Context, class string, version uint64) (models.MultiTenancyConfig, error) {
	ret := _m.Called(ctx, class, version)

	if len(ret) == 0 {
		panic("no return value specified for MultiTenancyWithVersion")
	}

	var r0 models.MultiTenancyConfig
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, uint64) (models.MultiTenancyConfig, error)); ok {
		return rf(ctx, class, version)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, uint64) models.MultiTenancyConfig); ok {
		r0 = rf(ctx, class, version)
	} else {
		r0 = ret.Get(0).(models.MultiTenancyConfig)
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, uint64) error); ok {
		r1 = rf(ctx, class, version)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_MultiTenancyWithVersion_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'MultiTenancyWithVersion'
type MockSchemaReader_MultiTenancyWithVersion_Call struct {
	*mock.Call
}

// MultiTenancyWithVersion is a helper method to define mock.On call
//   - ctx context.Context
//   - class string
//   - version uint64
func (_e *MockSchemaReader_Expecter) MultiTenancyWithVersion(ctx interface{}, class interface{}, version interface{}) *MockSchemaReader_MultiTenancyWithVersion_Call {
	return &MockSchemaReader_MultiTenancyWithVersion_Call{Call: _e.mock.On("MultiTenancyWithVersion", ctx, class, version)}
}

func (_c *MockSchemaReader_MultiTenancyWithVersion_Call) Run(run func(ctx context.Context, class string, version uint64)) *MockSchemaReader_MultiTenancyWithVersion_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(string), args[2].(uint64))
	})
	return _c
}

func (_c *MockSchemaReader_MultiTenancyWithVersion_Call) Return(_a0 models.MultiTenancyConfig, _a1 error) *MockSchemaReader_MultiTenancyWithVersion_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_MultiTenancyWithVersion_Call) RunAndReturn(run func(context.Context, string, uint64) (models.MultiTenancyConfig, error)) *MockSchemaReader_MultiTenancyWithVersion_Call {
	_c.Call.Return(run)
	return _c
}

// Read provides a mock function with given fields: class, retryIfClassNotFound, reader
func (_m *MockSchemaReader) Read(class string, retryIfClassNotFound bool, reader func(*models.Class, *sharding.State) error) error {
	ret := _m.Called(class, retryIfClassNotFound, reader)

	if len(ret) == 0 {
		panic("no return value specified for Read")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, bool, func(*models.Class, *sharding.State) error) error); ok {
		r0 = rf(class, retryIfClassNotFound, reader)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockSchemaReader_Read_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Read'
type MockSchemaReader_Read_Call struct {
	*mock.Call
}

// Read is a helper method to define mock.On call
//   - class string
//   - retryIfClassNotFound bool
//   - reader func(*models.Class , *sharding.State) error
func (_e *MockSchemaReader_Expecter) Read(class interface{}, retryIfClassNotFound interface{}, reader interface{}) *MockSchemaReader_Read_Call {
	return &MockSchemaReader_Read_Call{Call: _e.mock.On("Read", class, retryIfClassNotFound, reader)}
}

func (_c *MockSchemaReader_Read_Call) Run(run func(class string, retryIfClassNotFound bool, reader func(*models.Class, *sharding.State) error)) *MockSchemaReader_Read_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].(bool), args[2].(func(*models.Class, *sharding.State) error))
	})
	return _c
}

func (_c *MockSchemaReader_Read_Call) Return(_a0 error) *MockSchemaReader_Read_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_Read_Call) RunAndReturn(run func(string, bool, func(*models.Class, *sharding.State) error) error) *MockSchemaReader_Read_Call {
	_c.Call.Return(run)
	return _c
}

// ReadOnlyClass provides a mock function with given fields: name
func (_m *MockSchemaReader) ReadOnlyClass(name string) *models.Class {
	ret := _m.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for ReadOnlyClass")
	}

	var r0 *models.Class
	if rf, ok := ret.Get(0).(func(string) *models.Class); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Class)
		}
	}

	return r0
}

// MockSchemaReader_ReadOnlyClass_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ReadOnlyClass'
type MockSchemaReader_ReadOnlyClass_Call struct {
	*mock.Call
}

// ReadOnlyClass is a helper method to define mock.On call
//   - name string
func (_e *MockSchemaReader_Expecter) ReadOnlyClass(name interface{}) *MockSchemaReader_ReadOnlyClass_Call {
	return &MockSchemaReader_ReadOnlyClass_Call{Call: _e.mock.On("ReadOnlyClass", name)}
}

func (_c *MockSchemaReader_ReadOnlyClass_Call) Run(run func(name string)) *MockSchemaReader_ReadOnlyClass_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockSchemaReader_ReadOnlyClass_Call) Return(_a0 *models.Class) *MockSchemaReader_ReadOnlyClass_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_ReadOnlyClass_Call) RunAndReturn(run func(string) *models.Class) *MockSchemaReader_ReadOnlyClass_Call {
	_c.Call.Return(run)
	return _c
}

// ReadOnlyClassWithVersion provides a mock function with given fields: ctx, class, version
func (_m *MockSchemaReader) ReadOnlyClassWithVersion(ctx context.Context, class string, version uint64) (*models.Class, error) {
	ret := _m.Called(ctx, class, version)

	if len(ret) == 0 {
		panic("no return value specified for ReadOnlyClassWithVersion")
	}

	var r0 *models.Class
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, uint64) (*models.Class, error)); ok {
		return rf(ctx, class, version)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, uint64) *models.Class); ok {
		r0 = rf(ctx, class, version)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*models.Class)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, uint64) error); ok {
		r1 = rf(ctx, class, version)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_ReadOnlyClassWithVersion_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ReadOnlyClassWithVersion'
type MockSchemaReader_ReadOnlyClassWithVersion_Call struct {
	*mock.Call
}

// ReadOnlyClassWithVersion is a helper method to define mock.On call
//   - ctx context.Context
//   - class string
//   - version uint64
func (_e *MockSchemaReader_Expecter) ReadOnlyClassWithVersion(ctx interface{}, class interface{}, version interface{}) *MockSchemaReader_ReadOnlyClassWithVersion_Call {
	return &MockSchemaReader_ReadOnlyClassWithVersion_Call{Call: _e.mock.On("ReadOnlyClassWithVersion", ctx, class, version)}
}

func (_c *MockSchemaReader_ReadOnlyClassWithVersion_Call) Run(run func(ctx context.Context, class string, version uint64)) *MockSchemaReader_ReadOnlyClassWithVersion_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(string), args[2].(uint64))
	})
	return _c
}

func (_c *MockSchemaReader_ReadOnlyClassWithVersion_Call) Return(_a0 *models.Class, _a1 error) *MockSchemaReader_ReadOnlyClassWithVersion_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_ReadOnlyClassWithVersion_Call) RunAndReturn(run func(context.Context, string, uint64) (*models.Class, error)) *MockSchemaReader_ReadOnlyClassWithVersion_Call {
	_c.Call.Return(run)
	return _c
}

// ReadOnlySchema provides a mock function with no fields
func (_m *MockSchemaReader) ReadOnlySchema() models.Schema {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for ReadOnlySchema")
	}

	var r0 models.Schema
	if rf, ok := ret.Get(0).(func() models.Schema); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(models.Schema)
	}

	return r0
}

// MockSchemaReader_ReadOnlySchema_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ReadOnlySchema'
type MockSchemaReader_ReadOnlySchema_Call struct {
	*mock.Call
}

// ReadOnlySchema is a helper method to define mock.On call
func (_e *MockSchemaReader_Expecter) ReadOnlySchema() *MockSchemaReader_ReadOnlySchema_Call {
	return &MockSchemaReader_ReadOnlySchema_Call{Call: _e.mock.On("ReadOnlySchema")}
}

func (_c *MockSchemaReader_ReadOnlySchema_Call) Run(run func()) *MockSchemaReader_ReadOnlySchema_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockSchemaReader_ReadOnlySchema_Call) Return(_a0 models.Schema) *MockSchemaReader_ReadOnlySchema_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_ReadOnlySchema_Call) RunAndReturn(run func() models.Schema) *MockSchemaReader_ReadOnlySchema_Call {
	_c.Call.Return(run)
	return _c
}

// ReadOnlyVersionedClass provides a mock function with given fields: name
func (_m *MockSchemaReader) ReadOnlyVersionedClass(name string) versioned.Class {
	ret := _m.Called(name)

	if len(ret) == 0 {
		panic("no return value specified for ReadOnlyVersionedClass")
	}

	var r0 versioned.Class
	if rf, ok := ret.Get(0).(func(string) versioned.Class); ok {
		r0 = rf(name)
	} else {
		r0 = ret.Get(0).(versioned.Class)
	}

	return r0
}

// MockSchemaReader_ReadOnlyVersionedClass_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ReadOnlyVersionedClass'
type MockSchemaReader_ReadOnlyVersionedClass_Call struct {
	*mock.Call
}

// ReadOnlyVersionedClass is a helper method to define mock.On call
//   - name string
func (_e *MockSchemaReader_Expecter) ReadOnlyVersionedClass(name interface{}) *MockSchemaReader_ReadOnlyVersionedClass_Call {
	return &MockSchemaReader_ReadOnlyVersionedClass_Call{Call: _e.mock.On("ReadOnlyVersionedClass", name)}
}

func (_c *MockSchemaReader_ReadOnlyVersionedClass_Call) Run(run func(name string)) *MockSchemaReader_ReadOnlyVersionedClass_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockSchemaReader_ReadOnlyVersionedClass_Call) Return(_a0 versioned.Class) *MockSchemaReader_ReadOnlyVersionedClass_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_ReadOnlyVersionedClass_Call) RunAndReturn(run func(string) versioned.Class) *MockSchemaReader_ReadOnlyVersionedClass_Call {
	_c.Call.Return(run)
	return _c
}

// ReadSchema provides a mock function with given fields: reader
func (_m *MockSchemaReader) ReadSchema(reader func(models.Class, uint64)) error {
	ret := _m.Called(reader)

	if len(ret) == 0 {
		panic("no return value specified for ReadSchema")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(func(models.Class, uint64)) error); ok {
		r0 = rf(reader)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockSchemaReader_ReadSchema_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ReadSchema'
type MockSchemaReader_ReadSchema_Call struct {
	*mock.Call
}

// ReadSchema is a helper method to define mock.On call
//   - reader func(models.Class , uint64)
func (_e *MockSchemaReader_Expecter) ReadSchema(reader interface{}) *MockSchemaReader_ReadSchema_Call {
	return &MockSchemaReader_ReadSchema_Call{Call: _e.mock.On("ReadSchema", reader)}
}

func (_c *MockSchemaReader_ReadSchema_Call) Run(run func(reader func(models.Class, uint64))) *MockSchemaReader_ReadSchema_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(func(models.Class, uint64)))
	})
	return _c
}

func (_c *MockSchemaReader_ReadSchema_Call) Return(_a0 error) *MockSchemaReader_ReadSchema_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_ReadSchema_Call) RunAndReturn(run func(func(models.Class, uint64)) error) *MockSchemaReader_ReadSchema_Call {
	_c.Call.Return(run)
	return _c
}

// ResolveAlias provides a mock function with given fields: alias
func (_m *MockSchemaReader) ResolveAlias(alias string) string {
	ret := _m.Called(alias)

	if len(ret) == 0 {
		panic("no return value specified for ResolveAlias")
	}

	var r0 string
	if rf, ok := ret.Get(0).(func(string) string); ok {
		r0 = rf(alias)
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// MockSchemaReader_ResolveAlias_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ResolveAlias'
type MockSchemaReader_ResolveAlias_Call struct {
	*mock.Call
}

// ResolveAlias is a helper method to define mock.On call
//   - alias string
func (_e *MockSchemaReader_Expecter) ResolveAlias(alias interface{}) *MockSchemaReader_ResolveAlias_Call {
	return &MockSchemaReader_ResolveAlias_Call{Call: _e.mock.On("ResolveAlias", alias)}
}

func (_c *MockSchemaReader_ResolveAlias_Call) Run(run func(alias string)) *MockSchemaReader_ResolveAlias_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockSchemaReader_ResolveAlias_Call) Return(_a0 string) *MockSchemaReader_ResolveAlias_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_ResolveAlias_Call) RunAndReturn(run func(string) string) *MockSchemaReader_ResolveAlias_Call {
	_c.Call.Return(run)
	return _c
}

// ShardFromUUID provides a mock function with given fields: class, uuid
func (_m *MockSchemaReader) ShardFromUUID(class string, uuid []byte) string {
	ret := _m.Called(class, uuid)

	if len(ret) == 0 {
		panic("no return value specified for ShardFromUUID")
	}

	var r0 string
	if rf, ok := ret.Get(0).(func(string, []byte) string); ok {
		r0 = rf(class, uuid)
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// MockSchemaReader_ShardFromUUID_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ShardFromUUID'
type MockSchemaReader_ShardFromUUID_Call struct {
	*mock.Call
}

// ShardFromUUID is a helper method to define mock.On call
//   - class string
//   - uuid []byte
func (_e *MockSchemaReader_Expecter) ShardFromUUID(class interface{}, uuid interface{}) *MockSchemaReader_ShardFromUUID_Call {
	return &MockSchemaReader_ShardFromUUID_Call{Call: _e.mock.On("ShardFromUUID", class, uuid)}
}

func (_c *MockSchemaReader_ShardFromUUID_Call) Run(run func(class string, uuid []byte)) *MockSchemaReader_ShardFromUUID_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].([]byte))
	})
	return _c
}

func (_c *MockSchemaReader_ShardFromUUID_Call) Return(_a0 string) *MockSchemaReader_ShardFromUUID_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_ShardFromUUID_Call) RunAndReturn(run func(string, []byte) string) *MockSchemaReader_ShardFromUUID_Call {
	_c.Call.Return(run)
	return _c
}

// ShardFromUUIDWithVersion provides a mock function with given fields: ctx, class, uuid, version
func (_m *MockSchemaReader) ShardFromUUIDWithVersion(ctx context.Context, class string, uuid []byte, version uint64) (string, error) {
	ret := _m.Called(ctx, class, uuid, version)

	if len(ret) == 0 {
		panic("no return value specified for ShardFromUUIDWithVersion")
	}

	var r0 string
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, []byte, uint64) (string, error)); ok {
		return rf(ctx, class, uuid, version)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, []byte, uint64) string); ok {
		r0 = rf(ctx, class, uuid, version)
	} else {
		r0 = ret.Get(0).(string)
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, []byte, uint64) error); ok {
		r1 = rf(ctx, class, uuid, version)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_ShardFromUUIDWithVersion_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ShardFromUUIDWithVersion'
type MockSchemaReader_ShardFromUUIDWithVersion_Call struct {
	*mock.Call
}

// ShardFromUUIDWithVersion is a helper method to define mock.On call
//   - ctx context.Context
//   - class string
//   - uuid []byte
//   - version uint64
func (_e *MockSchemaReader_Expecter) ShardFromUUIDWithVersion(ctx interface{}, class interface{}, uuid interface{}, version interface{}) *MockSchemaReader_ShardFromUUIDWithVersion_Call {
	return &MockSchemaReader_ShardFromUUIDWithVersion_Call{Call: _e.mock.On("ShardFromUUIDWithVersion", ctx, class, uuid, version)}
}

func (_c *MockSchemaReader_ShardFromUUIDWithVersion_Call) Run(run func(ctx context.Context, class string, uuid []byte, version uint64)) *MockSchemaReader_ShardFromUUIDWithVersion_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(string), args[2].([]byte), args[3].(uint64))
	})
	return _c
}

func (_c *MockSchemaReader_ShardFromUUIDWithVersion_Call) Return(_a0 string, _a1 error) *MockSchemaReader_ShardFromUUIDWithVersion_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_ShardFromUUIDWithVersion_Call) RunAndReturn(run func(context.Context, string, []byte, uint64) (string, error)) *MockSchemaReader_ShardFromUUIDWithVersion_Call {
	_c.Call.Return(run)
	return _c
}

// ShardOwner provides a mock function with given fields: class, shard
func (_m *MockSchemaReader) ShardOwner(class string, shard string) (string, error) {
	ret := _m.Called(class, shard)

	if len(ret) == 0 {
		panic("no return value specified for ShardOwner")
	}

	var r0 string
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (string, error)); ok {
		return rf(class, shard)
	}
	if rf, ok := ret.Get(0).(func(string, string) string); ok {
		r0 = rf(class, shard)
	} else {
		r0 = ret.Get(0).(string)
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(class, shard)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_ShardOwner_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ShardOwner'
type MockSchemaReader_ShardOwner_Call struct {
	*mock.Call
}

// ShardOwner is a helper method to define mock.On call
//   - class string
//   - shard string
func (_e *MockSchemaReader_Expecter) ShardOwner(class interface{}, shard interface{}) *MockSchemaReader_ShardOwner_Call {
	return &MockSchemaReader_ShardOwner_Call{Call: _e.mock.On("ShardOwner", class, shard)}
}

func (_c *MockSchemaReader_ShardOwner_Call) Run(run func(class string, shard string)) *MockSchemaReader_ShardOwner_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].(string))
	})
	return _c
}

func (_c *MockSchemaReader_ShardOwner_Call) Return(_a0 string, _a1 error) *MockSchemaReader_ShardOwner_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_ShardOwner_Call) RunAndReturn(run func(string, string) (string, error)) *MockSchemaReader_ShardOwner_Call {
	_c.Call.Return(run)
	return _c
}

// ShardOwnerWithVersion provides a mock function with given fields: ctx, lass, shard, version
func (_m *MockSchemaReader) ShardOwnerWithVersion(ctx context.Context, lass string, shard string, version uint64) (string, error) {
	ret := _m.Called(ctx, lass, shard, version)

	if len(ret) == 0 {
		panic("no return value specified for ShardOwnerWithVersion")
	}

	var r0 string
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, uint64) (string, error)); ok {
		return rf(ctx, lass, shard, version)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, string, uint64) string); ok {
		r0 = rf(ctx, lass, shard, version)
	} else {
		r0 = ret.Get(0).(string)
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, string, uint64) error); ok {
		r1 = rf(ctx, lass, shard, version)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_ShardOwnerWithVersion_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ShardOwnerWithVersion'
type MockSchemaReader_ShardOwnerWithVersion_Call struct {
	*mock.Call
}

// ShardOwnerWithVersion is a helper method to define mock.On call
//   - ctx context.Context
//   - lass string
//   - shard string
//   - version uint64
func (_e *MockSchemaReader_Expecter) ShardOwnerWithVersion(ctx interface{}, lass interface{}, shard interface{}, version interface{}) *MockSchemaReader_ShardOwnerWithVersion_Call {
	return &MockSchemaReader_ShardOwnerWithVersion_Call{Call: _e.mock.On("ShardOwnerWithVersion", ctx, lass, shard, version)}
}

func (_c *MockSchemaReader_ShardOwnerWithVersion_Call) Run(run func(ctx context.Context, lass string, shard string, version uint64)) *MockSchemaReader_ShardOwnerWithVersion_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(string), args[2].(string), args[3].(uint64))
	})
	return _c
}

func (_c *MockSchemaReader_ShardOwnerWithVersion_Call) Return(_a0 string, _a1 error) *MockSchemaReader_ShardOwnerWithVersion_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_ShardOwnerWithVersion_Call) RunAndReturn(run func(context.Context, string, string, uint64) (string, error)) *MockSchemaReader_ShardOwnerWithVersion_Call {
	_c.Call.Return(run)
	return _c
}

// ShardReplicas provides a mock function with given fields: class, shard
func (_m *MockSchemaReader) ShardReplicas(class string, shard string) ([]string, error) {
	ret := _m.Called(class, shard)

	if len(ret) == 0 {
		panic("no return value specified for ShardReplicas")
	}

	var r0 []string
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) ([]string, error)); ok {
		return rf(class, shard)
	}
	if rf, ok := ret.Get(0).(func(string, string) []string); ok {
		r0 = rf(class, shard)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(class, shard)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_ShardReplicas_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ShardReplicas'
type MockSchemaReader_ShardReplicas_Call struct {
	*mock.Call
}

// ShardReplicas is a helper method to define mock.On call
//   - class string
//   - shard string
func (_e *MockSchemaReader_Expecter) ShardReplicas(class interface{}, shard interface{}) *MockSchemaReader_ShardReplicas_Call {
	return &MockSchemaReader_ShardReplicas_Call{Call: _e.mock.On("ShardReplicas", class, shard)}
}

func (_c *MockSchemaReader_ShardReplicas_Call) Run(run func(class string, shard string)) *MockSchemaReader_ShardReplicas_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].(string))
	})
	return _c
}

func (_c *MockSchemaReader_ShardReplicas_Call) Return(_a0 []string, _a1 error) *MockSchemaReader_ShardReplicas_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_ShardReplicas_Call) RunAndReturn(run func(string, string) ([]string, error)) *MockSchemaReader_ShardReplicas_Call {
	_c.Call.Return(run)
	return _c
}

// ShardReplicasWithVersion provides a mock function with given fields: ctx, class, shard, version
func (_m *MockSchemaReader) ShardReplicasWithVersion(ctx context.Context, class string, shard string, version uint64) ([]string, error) {
	ret := _m.Called(ctx, class, shard, version)

	if len(ret) == 0 {
		panic("no return value specified for ShardReplicasWithVersion")
	}

	var r0 []string
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, uint64) ([]string, error)); ok {
		return rf(ctx, class, shard, version)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, string, uint64) []string); ok {
		r0 = rf(ctx, class, shard, version)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, string, uint64) error); ok {
		r1 = rf(ctx, class, shard, version)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_ShardReplicasWithVersion_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ShardReplicasWithVersion'
type MockSchemaReader_ShardReplicasWithVersion_Call struct {
	*mock.Call
}

// ShardReplicasWithVersion is a helper method to define mock.On call
//   - ctx context.Context
//   - class string
//   - shard string
//   - version uint64
func (_e *MockSchemaReader_Expecter) ShardReplicasWithVersion(ctx interface{}, class interface{}, shard interface{}, version interface{}) *MockSchemaReader_ShardReplicasWithVersion_Call {
	return &MockSchemaReader_ShardReplicasWithVersion_Call{Call: _e.mock.On("ShardReplicasWithVersion", ctx, class, shard, version)}
}

func (_c *MockSchemaReader_ShardReplicasWithVersion_Call) Run(run func(ctx context.Context, class string, shard string, version uint64)) *MockSchemaReader_ShardReplicasWithVersion_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(string), args[2].(string), args[3].(uint64))
	})
	return _c
}

func (_c *MockSchemaReader_ShardReplicasWithVersion_Call) Return(_a0 []string, _a1 error) *MockSchemaReader_ShardReplicasWithVersion_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_ShardReplicasWithVersion_Call) RunAndReturn(run func(context.Context, string, string, uint64) ([]string, error)) *MockSchemaReader_ShardReplicasWithVersion_Call {
	_c.Call.Return(run)
	return _c
}

// Shards provides a mock function with given fields: class
func (_m *MockSchemaReader) Shards(class string) ([]string, error) {
	ret := _m.Called(class)

	if len(ret) == 0 {
		panic("no return value specified for Shards")
	}

	var r0 []string
	var r1 error
	if rf, ok := ret.Get(0).(func(string) ([]string, error)); ok {
		return rf(class)
	}
	if rf, ok := ret.Get(0).(func(string) []string); ok {
		r0 = rf(class)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(class)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_Shards_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Shards'
type MockSchemaReader_Shards_Call struct {
	*mock.Call
}

// Shards is a helper method to define mock.On call
//   - class string
func (_e *MockSchemaReader_Expecter) Shards(class interface{}) *MockSchemaReader_Shards_Call {
	return &MockSchemaReader_Shards_Call{Call: _e.mock.On("Shards", class)}
}

func (_c *MockSchemaReader_Shards_Call) Run(run func(class string)) *MockSchemaReader_Shards_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockSchemaReader_Shards_Call) Return(_a0 []string, _a1 error) *MockSchemaReader_Shards_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_Shards_Call) RunAndReturn(run func(string) ([]string, error)) *MockSchemaReader_Shards_Call {
	_c.Call.Return(run)
	return _c
}

// TenantsShardsWithVersion provides a mock function with given fields: ctx, version, class, tenants
func (_m *MockSchemaReader) TenantsShardsWithVersion(ctx context.Context, version uint64, class string, tenants ...string) (map[string]string, error) {
	_va := make([]interface{}, len(tenants))
	for _i := range tenants {
		_va[_i] = tenants[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, ctx, version, class)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for TenantsShardsWithVersion")
	}

	var r0 map[string]string
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, uint64, string, ...string) (map[string]string, error)); ok {
		return rf(ctx, version, class, tenants...)
	}
	if rf, ok := ret.Get(0).(func(context.Context, uint64, string, ...string) map[string]string); ok {
		r0 = rf(ctx, version, class, tenants...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]string)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, uint64, string, ...string) error); ok {
		r1 = rf(ctx, version, class, tenants...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockSchemaReader_TenantsShardsWithVersion_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'TenantsShardsWithVersion'
type MockSchemaReader_TenantsShardsWithVersion_Call struct {
	*mock.Call
}

// TenantsShardsWithVersion is a helper method to define mock.On call
//   - ctx context.Context
//   - version uint64
//   - class string
//   - tenants ...string
func (_e *MockSchemaReader_Expecter) TenantsShardsWithVersion(ctx interface{}, version interface{}, class interface{}, tenants ...interface{}) *MockSchemaReader_TenantsShardsWithVersion_Call {
	return &MockSchemaReader_TenantsShardsWithVersion_Call{Call: _e.mock.On("TenantsShardsWithVersion",
		append([]interface{}{ctx, version, class}, tenants...)...)}
}

func (_c *MockSchemaReader_TenantsShardsWithVersion_Call) Run(run func(ctx context.Context, version uint64, class string, tenants ...string)) *MockSchemaReader_TenantsShardsWithVersion_Call {
	_c.Call.Run(func(args mock.Arguments) {
		variadicArgs := make([]string, len(args)-3)
		for i, a := range args[3:] {
			if a != nil {
				variadicArgs[i] = a.(string)
			}
		}
		run(args[0].(context.Context), args[1].(uint64), args[2].(string), variadicArgs...)
	})
	return _c
}

func (_c *MockSchemaReader_TenantsShardsWithVersion_Call) Return(_a0 map[string]string, _a1 error) *MockSchemaReader_TenantsShardsWithVersion_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockSchemaReader_TenantsShardsWithVersion_Call) RunAndReturn(run func(context.Context, uint64, string, ...string) (map[string]string, error)) *MockSchemaReader_TenantsShardsWithVersion_Call {
	_c.Call.Return(run)
	return _c
}

// WaitForUpdate provides a mock function with given fields: ctx, version
func (_m *MockSchemaReader) WaitForUpdate(ctx context.Context, version uint64) error {
	ret := _m.Called(ctx, version)

	if len(ret) == 0 {
		panic("no return value specified for WaitForUpdate")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, uint64) error); ok {
		r0 = rf(ctx, version)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockSchemaReader_WaitForUpdate_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'WaitForUpdate'
type MockSchemaReader_WaitForUpdate_Call struct {
	*mock.Call
}

// WaitForUpdate is a helper method to define mock.On call
//   - ctx context.Context
//   - version uint64
func (_e *MockSchemaReader_Expecter) WaitForUpdate(ctx interface{}, version interface{}) *MockSchemaReader_WaitForUpdate_Call {
	return &MockSchemaReader_WaitForUpdate_Call{Call: _e.mock.On("WaitForUpdate", ctx, version)}
}

func (_c *MockSchemaReader_WaitForUpdate_Call) Run(run func(ctx context.Context, version uint64)) *MockSchemaReader_WaitForUpdate_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(context.Context), args[1].(uint64))
	})
	return _c
}

func (_c *MockSchemaReader_WaitForUpdate_Call) Return(_a0 error) *MockSchemaReader_WaitForUpdate_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockSchemaReader_WaitForUpdate_Call) RunAndReturn(run func(context.Context, uint64) error) *MockSchemaReader_WaitForUpdate_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockSchemaReader creates a new instance of MockSchemaReader. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockSchemaReader(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockSchemaReader {
	mock := &MockSchemaReader{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
