# -*- coding: utf-8 -*-
# Generated by Django 1.9.4 on 2017-04-25 09:25
from __future__ import unicode_literals

from django.db import migrations


def createParsers(apps, schema_editor):
    ScriptParameter = apps.get_model("wooey", "ScriptParameter")
    ScriptParser = apps.get_model("wooey", "ScriptParser")

    for param in ScriptParameter.objects.all():
        script_version = param.script_version.last()
        parser = list(
            ScriptParser.objects.filter(script_version__script=script_version.script)
        )
        if parser:
            parser = parser[-1]
        else:
            parser = ScriptParser(
                script_version=script_version,
                name="",
            )
            parser.save()
        param.parser = parser
        param.save()


class Migration(migrations.Migration):

    dependencies = [
        ("wooey", "0028_add_script_subparser"),
    ]

    operations = [
        migrations.RunPython(createParsers),
    ]
