# Contributing to OpenAgents

🎉 First off, a huge thank you for considering contributing to OpenAgents! 🎉 Your support is what keeps this project alive and constantly improving. OpenAgents is an evolving open-source project, and every contribution, no matter how big or small, adds significant value.

Contributions can come in various forms: adding new features, refining our infrastructure, enhancing documentation, or resolving bugs. Your experience and perspective are unique, and we can't wait to see what you bring to the project.

Helping doesn't only come in the form of code contributions. If you could spread the word about OpenAgents, reference us in your blog posts, shout out on Twitter, or give us a ⭐️ on GitHub, that would be incredible!

## 🌟 Getting Started

### How to Contribute?
We use a ["fork and pull request"](https://docs.github.com/en/get-started/quickstart/contributing-to-projects) model. Please avoid pushing directly to the main repo unless you're a maintainer.
Following the steps when you would like to make a contribution will be well-received:

- **Step 1:** If you're looking to add new features, enhance existing ones, or if you've stumbled upon a problem, please create an [issue](https://github.com/xlang-ai/OpenAgents/issues) . Our community will engage in a discussion to understand and assign the issue. Feel free to claim any open issues that catch your interest. For typos or grammar corrections, please refer to our dedicated [central issue](https://github.com/xlang-ai/OpenAgents/issues/26), where you can leave your suggestions.
- **Step 2:** Once an issue has been assigned to you, showcase your contributions through a [Pull Request (PR)](https://github.com/xlang-ai/OpenAgents/pulls). Together, we'll work towards making OpenAgents even better!
- **Step 3:** PR will be merged or further iterated upon after review and discussion. 🚀 Your contributions are invaluable to us—thank you!

### Creating Issues
When raising an issue, please use the provided templates. This helps us address your concerns more efficiently.

#### Do you find a bug or deployment issue?
If the bug hasn’t been reported yet, please include the following details in your issue to expedite the resolution process:

1. Your OS type and version and Python, LangChain and other relevant package versions if applicable.
2. A short, self-contained, code snippet that can help us to reproduce the bug if possible.
3. The full traceback if an exception is raised.
4. Any other additional information, like screenshots, you think may help.

#### Do you want to add a new model/agent/tool?
We warmly welcome new models/agents/tools to be added to OpenAgents. Please follow the next template of "new feature" to open an issue. 

#### Do you want a new feature or enhancement to an existing feature?
If there is a new feature you'd like to see in OpenAgents, please open an issue and describe:

1. What is the *motivation* behind this feature? We’re eager to understand your perspective!
2. Details about your requested feature if possible. The more you can tell us about it, the better we can offer help.
3. If the feature is related to a paper or reference, please include a link.

#### Do you want to add documentation?
For minor typos and grammar issues, please contribute to our [centralized issue for text corrections](https://github.com/xlang-ai/OpenAgents/issues/26). For more substantial documentation additions or improvements, please open a new issue, detailing how the documentation can be improved such as any content that is missing, unclear or inaccurate. 
We'll be happy to make the changes or help you make a contribution if you're interested!


### Pull Requests   
When initiating a pull request, please adhere to the provided template.

+ A title summarizing what the PR does
+ A reference to the fixed issue (if applicable), e.g., Fix #(issue number).
+ A short description of the PR contents if necessary.


## 🚀 Quick Setup
Jump right in and set up your environment with ease:

- **Frontend**: Get started with the frontend by following the guidelines [here](https://github.com/xlang-ai/OpenAgents/blob/main/frontend/README.md).
- **Backend**: Set up the backend using instructions available [here](https://github.com/xlang-ai/OpenAgents/blob/main/backend/README.md).

We’re thrilled to have you on board, and we can’t wait to see the incredible contributions you’ll bring to OpenAgents! 🌟 Happy coding!