import httpx
import pytest

from nicegui import __version__, ui
from nicegui.testing import Screen


@pytest.fixture(autouse=True)
def activate_fastapi_docs(screen: Screen):
    screen.ui_run_kwargs['fastapi_docs'] = True


def get_openapi_paths() -> set[str]:
    return set(httpx.get(f'http://localhost:{Screen.PORT}/openapi.json', timeout=5).json()['paths'])


def test_endpoint_documentation_default(screen: Screen):
    @ui.page('/')
    def page():
        ui.markdown('Hey!')

    screen.open('/')
    assert get_openapi_paths() == set()


def test_endpoint_documentation_page_only(screen: Screen):
    screen.ui_run_kwargs['endpoint_documentation'] = 'page'

    @ui.page('/')
    def page():
        ui.markdown('Hey!')

    screen.open('/')
    assert get_openapi_paths() == {'/'}


def test_endpoint_documentation_internal_only(screen: Screen):
    screen.ui_run_kwargs['endpoint_documentation'] = 'internal'

    @ui.page('/')
    def page():
        ui.markdown('Hey!')

    screen.open('/')
    assert get_openapi_paths() == {
        f'/_nicegui/{__version__}/libraries/{{key}}',
        f'/_nicegui/{__version__}/components/{{key}}',
        f'/_nicegui/{__version__}/resources/{{key}}/{{path}}',
        f'/_nicegui/{__version__}/dynamic_resources/{{name}}',
        f'/_nicegui/{__version__}/esm/{{key}}/{{path}}',
    }


def test_endpoint_documentation_all(screen: Screen):
    screen.ui_run_kwargs['endpoint_documentation'] = 'all'

    @ui.page('/')
    def page():
        ui.markdown('Hey!')

    screen.open('/')
    assert get_openapi_paths() == {
        '/',
        f'/_nicegui/{__version__}/libraries/{{key}}',
        f'/_nicegui/{__version__}/components/{{key}}',
        f'/_nicegui/{__version__}/resources/{{key}}/{{path}}',
        f'/_nicegui/{__version__}/dynamic_resources/{{name}}',
        f'/_nicegui/{__version__}/esm/{{key}}/{{path}}',
    }
