# Contribution Guidelines

## Please ensure your pull request adheres to the following guidelines:

* Make sure your submission is not a duplicate.
* Follow the following format: `[RESOURCE](LINK) - DESCRIPTION.`
* Keep descriptions short and simple.
* End all descriptions with a full stop.
* Check your spelling and grammar.
* Make an individual pull request for each suggestion.
* The pull request and commit should have a useful title.
* Indent lines with spaces, not tabs.

Once a PR is submitted, it will need to be "endorsed". This entails that your pull request will be merged once more people show interest in your suggestion (i.e. react positively, comment on your pull-req etc).

 You can vote on Pull Requests with the [endorsement-needed](https://github.com/zenitysec/awesome-low-code/labels/endorsement-needed) tag.

Please note that this project is released with a [Contributor Code of Conduct](code-of-conduct.md). 
By participating in this project you agree to abide by its terms.

Thank you for your suggestions!

## Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult.
If the maintainers notice anything that we'd like changed, we'll ask you to
edit your PR before we merge it. There's no need to open a new PR, just edit
the existing one. If you're not sure how to do that,
[here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md)
on the different ways you can update your PR so that we can merge it.