'use client'

import { cn, withRef } from '@udecode/cn'
import { useEditorRef, withHOC } from '@udecode/plate-common/react'
import { useDraggable, useDraggableState } from '@udecode/plate-dnd'
import { Image, ImagePlugin, useMediaState } from '@udecode/plate-media/react'
import { ResizableProvider, useResizableStore } from '@udecode/plate-resizable'

import { Caption, CaptionTextarea } from './caption'
import { MediaPopover } from './media-popover'
import { PlateElement } from './plate-element'
import { Resizable, ResizeHandle, mediaResizeHandleVariants } from './resizable'

export const ImageElement = withHOC(
  ResizableProvider,
  withRef<typeof PlateElement>(({ children, className, nodeProps, ...props }, ref) => {
    const editor = useEditorRef()

    const { align = 'center', focused, readOnly, selected } = useMediaState()

    const width = useResizableStore().get.width()

    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const state = editor.plugins.dnd ? useDraggableState({ element: props.element }) : ({} as any)

    const { isDragging } = state
    const { handleRef } = useDraggable(state)

    return (
      <MediaPopover plugin={ImagePlugin}>
        <PlateElement ref={ref} className={cn('py-2.5', className)} {...props}>
          <figure className="group relative m-0" contentEditable={false}>
            <Resizable
              align={align}
              options={{
                align,
                readOnly,
              }}
            >
              <ResizeHandle
                className={mediaResizeHandleVariants({ direction: 'left' })}
                options={{ direction: 'left' }}
              />
              <Image
                ref={handleRef}
                className={cn(
                  'block w-full max-w-full cursor-pointer object-cover px-0',
                  'rounded-sm',
                  focused && selected && 'ring-2 ring-ring ring-offset-2',
                  isDragging && 'opacity-50',
                )}
                alt=""
                {...nodeProps}
              />
              <ResizeHandle
                className={mediaResizeHandleVariants({
                  direction: 'right',
                })}
                options={{ direction: 'right' }}
              />
            </Resizable>

            <Caption style={{ width }} align={align}>
              <CaptionTextarea
                readOnly={readOnly}
                onFocus={(e) => {
                  e.preventDefault()
                }}
                placeholder="Write a caption..."
              />
            </Caption>
          </figure>

          {children}
        </PlateElement>
      </MediaPopover>
    )
  }),
)
