import { FileSystemTree } from '@webcontainer/api'

export const BASE: FileSystemTree = {
  src: {
    directory: {
      assets: {
        directory: {
          'todo.svg': {
            file: {
              contents: `<svg width="119" height="101" viewBox="0 0 119 101" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M111.332 91.2891H86.9336V91.3562H111.332V91.2891Z" fill="#EBEBEB"/>
<path d="M79.4736 90.5625H72.793V90.6296H79.4736V90.5625Z" fill="#EBEBEB"/>
<path d="M94.7406 93.7793H84.3828V93.8464H94.7406V93.7793Z" fill="#EBEBEB"/>
<path d="M10.7251 93.3301H4.64844V93.3972H10.7251V93.3301Z" fill="#EBEBEB"/>
<path d="M20.3346 93.3301H13.1172V93.3972H20.3346V93.3301Z" fill="#EBEBEB"/>
<path d="M51.0057 92.1973H38.4336V92.2644H51.0057V92.1973Z" fill="#EBEBEB"/>
<path d="M54.1843 76.7606H2.35803C1.95203 76.7598 1.5629 76.5981 1.27606 76.3107C0.989225 76.0233 0.828124 75.6339 0.828125 75.2279V2.37082C0.831659 1.96712 0.99432 1.58112 1.28077 1.29666C1.56723 1.0122 1.95434 0.852254 2.35803 0.851562H54.1843C54.5908 0.851563 54.9806 1.01304 55.268 1.30047C55.5555 1.5879 55.7169 1.97775 55.7169 2.38424V75.2279C55.7169 75.6344 55.5555 76.0242 55.268 76.3116C54.9806 76.5991 54.5908 76.7606 54.1843 76.7606ZM2.35803 0.905247C1.96983 0.905958 1.59776 1.06068 1.32351 1.33545C1.04926 1.61022 0.895226 1.98259 0.895226 2.37082V75.2279C0.895226 75.6161 1.04926 75.9885 1.32351 76.2632C1.59776 76.538 1.96983 76.6927 2.35803 76.6934H54.1843C54.5728 76.6927 54.9451 76.5381 55.2198 76.2634C55.4945 75.9887 55.6491 75.6164 55.6498 75.2279V2.37082C55.6491 1.98234 55.4945 1.60998 55.2198 1.33529C54.9451 1.06059 54.5728 0.905956 54.1843 0.905247H2.35803Z" fill="#EBEBEB"/>
<path d="M112.24 76.7606H60.4115C60.0052 76.7598 59.6158 76.5981 59.3286 76.3109C59.0413 76.0236 58.8796 75.6342 58.8789 75.2279V2.37082C58.8831 1.96688 59.0464 1.58088 59.3333 1.29649C59.6202 1.01211 60.0076 0.852247 60.4115 0.851562H112.24C112.644 0.852959 113.03 1.01322 113.316 1.2976C113.602 1.58199 113.764 1.96758 113.768 2.37082V75.2279C113.768 75.6334 113.607 76.0225 113.321 76.3097C113.034 76.597 112.646 76.7591 112.24 76.7606ZM60.4115 0.905247C60.023 0.905956 59.6507 1.06059 59.376 1.33529C59.1013 1.60998 58.9467 1.98234 58.946 2.37082V75.2279C58.9467 75.6164 59.1013 75.9887 59.376 76.2634C59.6507 76.5381 60.023 76.6927 60.4115 76.6934H112.24C112.629 76.6927 113.001 76.5381 113.276 76.2634C113.551 75.9887 113.705 75.6164 113.706 75.2279V2.37082C113.705 1.98234 113.551 1.60998 113.276 1.33529C113.001 1.06059 112.629 0.905956 112.24 0.905247H60.4115Z" fill="#EBEBEB"/>
<path d="M4.6517 88.7285H36.7422L36.7422 17.7557H4.6517L4.6517 88.7285Z" fill="#F0F0F0"/>
<path d="M4.65012 88.7285H35.2188L35.2187 17.7557H4.65012L4.65012 88.7285Z" fill="#F5F5F5"/>
<path d="M33.6094 87.1228L33.6094 19.3711H6.26159L6.26159 87.1228H33.6094Z" fill="#F0F0F0"/>
<path d="M15.1 51.3142H9.52523C9.33539 51.3135 9.15352 51.2378 9.01927 51.1035C8.88503 50.9693 8.8093 50.7874 8.80859 50.5975C8.8093 50.4077 8.88503 50.2258 9.01927 50.0915C9.15352 49.9573 9.33539 49.8816 9.52523 49.8809H15.1C15.2899 49.8816 15.4717 49.9573 15.606 50.0915C15.7402 50.2258 15.8159 50.4077 15.8166 50.5975C15.8159 50.7874 15.7402 50.9693 15.606 51.1035C15.4717 51.2378 15.2899 51.3135 15.1 51.3142Z" fill="white"/>
<path d="M6.67969 87.1228L6.67969 19.3711H6.26098L6.26098 87.1228H6.67969Z" fill="#F0F0F0"/>
<path d="M51.7771 87.3848H56.5547V66.6628H51.7771V87.3848Z" fill="#F0F0F0"/>
<path d="M32.0722 88.6992H55.6328V87.3867H32.0722V88.6992Z" fill="#F0F0F0"/>
<path d="M51.7751 66.668H31.1562V87.3899H51.7751V66.668Z" fill="#F5F5F5"/>
<path d="M49.8924 69.2148H33.0312V76.0112H49.8924V69.2148Z" fill="#F0F0F0"/>
<path d="M49.8924 78.0371H33.0312V84.8335H49.8924V78.0371Z" fill="#F0F0F0"/>
<path d="M39.5737 69.7869H43.3609C43.4838 69.7862 43.6015 69.737 43.6885 69.6501C43.7754 69.5632 43.8245 69.4455 43.8252 69.3225C43.8252 69.1991 43.7764 69.0807 43.6894 68.9932C43.6024 68.9057 43.4843 68.8562 43.3609 68.8555H39.5737C39.4503 68.8562 39.3322 68.9057 39.2452 68.9932C39.1582 69.0807 39.1094 69.1991 39.1094 69.3225C39.1101 69.4455 39.1592 69.5632 39.2462 69.6501C39.3331 69.737 39.4508 69.7862 39.5737 69.7869Z" fill="#F5F5F5"/>
<path d="M39.5737 78.6121H43.3609C43.4825 78.6114 43.599 78.5634 43.6857 78.4782C43.7724 78.393 43.8225 78.2773 43.8252 78.1558C43.8245 78.0328 43.7754 77.9151 43.6885 77.8282C43.6015 77.7413 43.4838 77.6921 43.3609 77.6914H39.5737C39.4508 77.6921 39.3331 77.7413 39.2462 77.8282C39.1592 77.9151 39.1101 78.0328 39.1094 78.1558C39.1122 78.2773 39.1622 78.393 39.2489 78.4782C39.3356 78.5634 39.4522 78.6114 39.5737 78.6121Z" fill="#F5F5F5"/>
<path d="M43.0379 66.2581C42.9441 66.2574 42.8544 66.2199 42.7881 66.1536C42.7218 66.0873 42.6843 65.9976 42.6836 65.9038V55.1375C42.6836 55.0435 42.7209 54.9534 42.7874 54.887C42.8538 54.8205 42.9439 54.7832 43.0379 54.7832C43.1316 54.7839 43.2213 54.8215 43.2876 54.8878C43.3539 54.9541 43.3915 55.0438 43.3922 55.1375V65.9038C43.3915 65.9976 43.3539 66.0873 43.2876 66.1536C43.2213 66.2199 43.1316 66.2574 43.0379 66.2581Z" fill="#F5F5F5"/>
<path d="M46.3523 65.8379H39.7227V66.6727H46.3523V65.8379Z" fill="#F0F0F0"/>
<path d="M44.8725 59.8133C44.8259 59.8133 44.7813 59.795 44.7481 59.7623C44.715 59.7297 44.696 59.6853 44.6953 59.6388V54.265C44.696 54.2183 44.7149 54.1736 44.748 54.1405C44.781 54.1075 44.8257 54.0886 44.8725 54.0879C44.9192 54.0886 44.9639 54.1075 44.997 54.1405C45.03 54.1736 45.0489 54.2183 45.0496 54.265V59.6334C45.05 59.6569 45.0456 59.6803 45.0369 59.7021C45.0282 59.7239 45.0152 59.7437 44.9987 59.7604C44.9822 59.7772 44.9625 59.7905 44.9409 59.7995C44.9192 59.8086 44.896 59.8133 44.8725 59.8133Z" fill="#F0F0F0"/>
<path d="M37.8828 56.118C37.8828 56.118 38.0143 51.0449 43.0389 51.0449C48.0634 51.0449 48.1922 56.1127 48.1922 56.1127L37.8828 56.118Z" fill="#F0F0F0"/>
<path d="M81.374 63.2871C81.5162 63.2871 81.6612 63.2871 81.8061 63.3005C83.2907 63.4078 84.6866 64.0479 85.7366 65.1029C86.7866 66.158 87.4201 67.5569 87.5205 69.042C87.5629 69.7167 87.4958 70.3938 87.3218 71.0471C86.649 73.6675 86.3241 76.365 86.3556 79.0702V86.9456C86.3559 87.082 86.3293 87.2171 86.2772 87.3431C86.2251 87.4692 86.1485 87.5836 86.052 87.68C85.9554 87.7763 85.8407 87.8525 85.7146 87.9043C85.5884 87.9561 85.4532 87.9824 85.3169 87.9817H60.3203V63.2871H81.374Z" fill="#F0F0F0"/>
<path d="M54.1641 69.4475C54.1667 68.5719 54.3561 67.7069 54.7195 66.9103C55.0829 66.1136 55.6121 65.4037 56.2717 64.8278C56.9312 64.2519 57.706 63.8233 58.5444 63.5706C59.3827 63.3179 60.2653 63.2469 61.1332 63.3624C62.0012 63.4778 62.8345 63.7771 63.5776 64.2402C64.3207 64.7033 64.9565 65.3196 65.4426 66.0479C65.9287 66.7762 66.2538 67.5999 66.3963 68.4638C66.5389 69.3278 66.4955 70.2122 66.2691 71.058C65.5984 73.6787 65.2745 76.3761 65.3055 79.0811V86.9565C65.3055 87.0925 65.2787 87.2271 65.2266 87.3526C65.1745 87.4782 65.0982 87.5922 65.0019 87.6882C64.9057 87.7842 64.7915 87.8603 64.6658 87.9121C64.5401 87.9638 64.4054 87.9903 64.2695 87.9899H56.3757C56.24 87.9899 56.1056 87.9632 55.9803 87.9113C55.8549 87.8593 55.741 87.7832 55.645 87.6873C55.5491 87.5913 55.4729 87.4774 55.421 87.352C55.3691 87.2266 55.3424 87.0922 55.3424 86.9565V78.6087C55.3652 76.0718 55.0437 73.5435 54.3868 71.0929C54.2388 70.557 54.1639 70.0035 54.1641 69.4475Z" fill="#F5F5F5"/>
<path d="M68.8126 87.9805H91.2539V72.9866H68.8126V87.9805Z" fill="#F0F0F0"/>
<path d="M109.797 76.3789H79.7597V53.3834C79.7597 52.1476 80.2506 50.9624 81.1244 50.0885C81.9982 49.2146 83.1834 48.7237 84.4192 48.7237H105.137C106.373 48.7237 107.558 49.2146 108.432 50.0885C109.306 50.9624 109.797 52.1476 109.797 53.3834V76.3789Z" fill="#E0E0E0"/>
<path d="M103.926 76.3789H73.8886V53.158C73.8886 51.9812 74.356 50.8526 75.1881 50.0205C76.0201 49.1884 77.1486 48.721 78.3253 48.721H99.4783C100.655 48.721 101.784 49.1884 102.616 50.0205C103.448 50.8526 103.915 51.9812 103.915 53.158V76.3789H103.926Z" fill="#F5F5F5"/>
<path d="M89.7822 77.7246H69.0962C68.7403 77.7246 68.399 77.5832 68.1473 77.3315C67.8956 77.0798 67.7542 76.7385 67.7542 76.3825V72.9816C67.7542 72.6257 67.8956 72.2843 68.1473 72.0326C68.399 71.7809 68.7403 71.6395 69.0962 71.6395H89.7822C89.8897 71.6395 89.9928 71.6822 90.0688 71.7583C90.1448 71.8343 90.1875 71.9374 90.1875 72.0449V77.322C90.1868 77.429 90.1438 77.5314 90.0678 77.6068C89.9919 77.6823 89.8892 77.7246 89.7822 77.7246Z" fill="#E0E0E0"/>
<path d="M112.013 63.2871C112.156 63.2871 112.298 63.2871 112.446 63.3005C113.93 63.4084 115.325 64.0488 116.374 65.1038C117.424 66.1587 118.057 67.5573 118.157 69.042C118.202 69.7168 118.135 70.3943 117.959 71.0471C117.285 73.6683 116.961 76.3668 116.992 79.0729V86.9483C116.992 87.0842 116.965 87.2188 116.913 87.3444C116.861 87.4699 116.785 87.584 116.689 87.68C116.592 87.776 116.478 87.852 116.353 87.9038C116.227 87.9556 116.092 87.982 115.956 87.9817H90.957V63.2871H112.013Z" fill="#F0F0F0"/>
<path d="M84.797 69.4471C84.7862 67.8418 85.4027 66.2957 86.5152 65.1383C87.6278 63.9809 89.1483 63.3038 90.7527 63.2513C92.3572 63.1988 93.9187 63.7751 95.1045 64.8572C96.2903 65.9394 97.0066 67.4419 97.1007 69.0445C97.1431 69.7192 97.076 70.3963 96.9021 71.0496C96.2292 73.6699 95.9043 76.3675 95.9358 79.0726V86.9481C95.9358 87.2221 95.827 87.485 95.6332 87.6788C95.4394 87.8726 95.1765 87.9815 94.9025 87.9815H87.006C86.8703 87.9815 86.7359 87.9548 86.6105 87.9028C86.4852 87.8509 86.3712 87.7748 86.2753 87.6788C86.1793 87.5828 86.1032 87.4689 86.0513 87.3435C85.9994 87.2182 85.9726 87.0838 85.9726 86.9481V78.6083C85.995 76.0715 85.6745 73.5434 85.0198 71.0925C84.8718 70.5566 84.7968 70.0031 84.797 69.4471Z" fill="#F5F5F5"/>
<path d="M60.7567 88.732H111.568C111.667 88.732 111.765 88.7126 111.856 88.6748C111.947 88.637 112.029 88.5816 112.099 88.5117C112.168 88.4419 112.224 88.359 112.261 88.2679C112.298 88.1767 112.318 88.079 112.317 87.9805H60.0078C60.0075 88.079 60.0266 88.1767 60.064 88.2679C60.1015 88.359 60.1566 88.4419 60.2262 88.5117C60.2958 88.5816 60.3784 88.637 60.4695 88.6748C60.5605 88.7126 60.6581 88.732 60.7567 88.732Z" fill="#E0E0E0"/>
<path d="M90.8521 31.1504L107.195 31.1504V13.3247L90.8521 13.3247V31.1504Z" fill="#E0E0E0"/>
<path d="M89.8812 31.1504L106.648 31.1504V13.3247L89.8812 13.3247V31.1504Z" fill="#F5F5F5"/>
<path d="M105.242 29.7466V14.7285H91.2825V29.7466H105.242Z" fill="white"/>
<path d="M98.262 18.4395L102.079 25.0533H94.4453L98.262 18.4395Z" fill="#F5F5F5"/>
<path d="M67.9264 41.5547H84.2695V23.729L67.9264 23.729V41.5547Z" fill="#E0E0E0"/>
<path d="M66.9476 41.5547H83.7148V23.729L66.9476 23.729V41.5547Z" fill="#F5F5F5"/>
<path d="M82.3086 40.1528V25.1348H68.3489V40.1528H82.3086Z" fill="white"/>
<path d="M73.6294 35.3181L71.9733 32.4487C71.801 32.1492 71.7106 31.8097 71.7109 31.4641C71.7113 31.1186 71.8026 30.7793 71.9755 30.4801C72.1484 30.181 72.397 29.9326 72.6962 29.7599C72.9955 29.5872 73.3349 29.4962 73.6804 29.4961H77.0006C77.346 29.4965 77.6852 29.5877 77.9844 29.7604C78.2835 29.9331 78.5321 30.1814 78.7052 30.4803C78.8783 30.7792 78.9698 31.1184 78.9707 31.4638C78.9716 31.8093 78.8818 32.1489 78.7103 32.4487L77.0542 35.3181C76.8816 35.6199 76.6323 35.8707 76.3316 36.0451C76.0309 36.2196 75.6895 36.3114 75.3418 36.3114C74.9942 36.3114 74.6527 36.2196 74.352 36.0451C74.0513 35.8707 73.802 35.6199 73.6294 35.3181Z" fill="#F5F5F5"/>
<path d="M57.6738 100.85C86.4153 100.85 109.715 99.4901 109.715 97.8119C109.715 96.1338 86.4153 94.7734 57.6738 94.7734C28.9324 94.7734 5.63281 96.1338 5.63281 97.8119C5.63281 99.4901 28.9324 100.85 57.6738 100.85Z" fill="#F5F5F5"/>
<path d="M75.5211 12.7422H13.6484L17.7201 97.0098H79.5928L75.5211 12.7422Z" fill="#6287FF"/>
<path opacity="0.2" d="M75.5211 12.7422H13.6484L17.7201 97.0098H79.5928L75.5211 12.7422Z" fill="black"/>
<path d="M76.0915 12.7422H14.2188L18.2931 97.0098H80.1658L76.0915 12.7422Z" fill="#6287FF"/>
<path opacity="0.2" d="M72.828 15.5762H17.0508L20.948 93.2004L69.4488 93.1359L77.509 85.9906L72.828 15.5762Z" fill="black"/>
<path d="M73.2548 15.5723C73.8495 38.8191 75.7268 62.0154 78.8779 85.0553C74.4581 88.0974 70.0608 91.1395 65.6858 94.1815H23.9703C20.0329 68.1477 17.7219 41.8937 17.0508 15.5723H73.2548Z" fill="white"/>
<path d="M78.8757 85.0561C74.456 88.0982 70.0586 91.1403 65.6836 94.1824C66.6391 90.1561 67.6349 86.1298 68.6709 82.1035L78.8757 85.0561Z" fill="#EBEBEB"/>
<path d="M32.1734 22.6746C32.279 25.5163 32.4025 28.3597 32.5438 31.205H24.0166C23.8735 28.3597 23.75 25.5163 23.6462 22.6746H32.1734ZM33.0431 21.7754H22.7148C22.8347 25.2165 22.9841 28.6595 23.1631 32.1042H33.494C33.315 28.6612 33.1656 25.2183 33.0457 21.7754H33.0431Z" fill="#6287FF"/>
<path d="M67.0174 25.8784H37.8095C37.7827 25.2369 37.7585 24.5927 37.7344 23.9512H66.9395C66.9637 24.5927 66.9905 25.2369 67.0174 25.8784Z" fill="#E0E0E0"/>
<path d="M60.8483 29.9312H37.9909C37.9614 29.2869 37.9292 28.6454 37.9023 28.0039H60.757C60.7874 28.6463 60.8179 29.2887 60.8483 29.9312Z" fill="#E0E0E0"/>
<path d="M33.0089 39.3836C33.1878 42.2288 33.3873 45.0741 33.6074 47.9193H25.0775C24.8574 45.0741 24.6579 42.2288 24.479 39.3836H33.0089ZM33.8517 38.4844H23.5234C23.7346 41.9291 23.9753 45.3738 24.2454 48.8185H34.5871C34.3187 45.3756 34.0771 41.9309 33.8624 38.4844H33.8517Z" fill="#6287FF"/>
<path d="M49.4588 42.5881H38.7226C38.6796 41.9439 38.634 41.3024 38.5938 40.6582H49.3299C49.3702 41.3024 49.4131 41.9439 49.4588 42.5881Z" fill="#E0E0E0"/>
<path d="M59.6281 42.5881H51.7343C51.6914 41.9439 51.6457 41.3024 51.6055 40.6582H59.4993C59.5395 41.3024 59.5825 41.9439 59.6281 42.5881Z" fill="#E0E0E0"/>
<path d="M64.5775 46.6448H39.0173C38.9689 46.0006 38.9233 45.3591 38.875 44.7148H64.4352C64.4835 45.3591 64.5291 46.0006 64.5775 46.6448Z" fill="#E0E0E0"/>
<path d="M34.2947 56.0965C34.5506 58.9417 34.8262 61.787 35.1214 64.6322H26.5915C26.2963 61.787 26.0207 58.9417 25.7648 56.0965H34.2947ZM35.1161 55.1973H24.7852C25.0893 58.6438 25.4222 62.0894 25.7836 65.5341H36.1145C35.7567 62.0876 35.4238 58.642 35.1161 55.1973Z" fill="#6287FF"/>
<path d="M69.5035 61.4297H40.293L40.4862 63.3569H69.6967L69.5035 61.4297Z" fill="#E0E0E0"/>
<path d="M62.7714 57.373H39.9141C39.9731 58.0146 40.0322 58.6588 40.0939 59.3003H62.9486C62.8895 58.6588 62.8278 58.0226 62.7714 57.373Z" fill="#E0E0E0"/>
<path d="M36.0181 72.8094C36.3509 75.6546 36.7025 78.499 37.0729 81.3424H28.543C28.1726 78.5007 27.821 75.6564 27.4882 72.8094H36.0181ZM36.8233 71.9102H26.4844C26.878 75.3567 27.303 78.8005 27.7593 82.2416H38.0795C37.6268 78.8005 37.2018 75.3567 36.8045 71.9102H36.8233Z" fill="#6287FF"/>
<path d="M71.1171 76.0081H41.9066C41.8288 75.3639 41.7509 74.7223 41.6758 74.0781H70.8836C70.9614 74.7304 71.0366 75.3719 71.1171 76.0081Z" fill="#E0E0E0"/>
<path d="M55.709 80.0698H42.4122C42.329 79.4283 42.2485 78.7841 42.168 78.1426H55.4647C55.5453 78.7841 55.6258 79.4283 55.709 80.0698Z" fill="#E0E0E0"/>
<path d="M63.6456 80.0698H57.9044C57.8212 79.4283 57.7407 78.7841 57.6602 78.1426H63.4013C63.4819 78.7841 63.5731 79.4283 63.6456 80.0698Z" fill="#E0E0E0"/>
<path d="M28.4146 29.9878L28.0361 29.3866C27.2094 28.0713 25.5238 26.8983 24.9414 26.5548L25.3762 25.7844C26.5189 26.4783 27.5399 27.3552 28.3985 28.38C29.6975 26.6111 31.6193 24.7832 34.2497 22.8184L34.8053 23.5431C31.9978 25.6448 30.033 27.5694 28.793 29.4215L28.4146 29.9878Z" fill="#6287FF"/>
<path d="M29.4406 46.7002L29.0461 46.099C28.1872 44.7837 26.4694 43.608 25.8789 43.2645L26.2896 42.4941C27.454 43.1883 28.499 44.0656 29.3843 45.0924C30.635 43.3208 32.5058 41.4929 35.0852 39.5254C35.2758 39.767 35.469 40.0085 35.6596 40.2528C32.9084 42.3572 30.9947 44.2791 29.8057 46.1339C29.6822 46.3218 29.5614 46.5123 29.4406 46.7002Z" fill="#6287FF"/>
<path d="M30.9174 63.458L30.5067 62.8568C29.6103 61.5415 27.8603 60.3659 27.2617 60.025C27.3906 59.7566 27.5301 59.5096 27.6536 59.2546C28.8362 59.9499 29.903 60.8257 30.8154 61.8502C32.0205 60.0787 33.843 58.2534 36.366 56.2832L36.9619 57.0106C34.2778 59.115 32.399 61.0369 31.2636 62.8917L30.9174 63.458Z" fill="#6287FF"/>
<path d="M57.9776 89.5533C56.394 89.5533 55.4815 88.9681 54.6762 88.4527C53.871 87.9374 53.1785 87.4918 51.8419 87.4918C50.5052 87.4918 49.9094 87.9588 49.2786 88.4527C48.6479 88.9466 47.8749 89.5533 46.2913 89.5533C44.7077 89.5533 43.7951 88.9681 42.9926 88.4527C42.19 87.9374 41.4976 87.4918 40.1582 87.4918C38.8189 87.4918 38.2257 87.9588 37.5949 88.4527C36.9642 88.9466 36.1912 89.5533 34.6103 89.5533C33.0294 89.5533 32.1141 88.9681 31.3089 88.4527C30.5037 87.9374 29.8139 87.4918 28.4746 87.4918C28.4397 87.2234 28.4021 86.9764 28.3672 86.7188C29.9508 86.7188 30.8607 87.3039 31.6659 87.8193C32.4711 88.3346 33.1609 88.7802 34.4976 88.7802C35.8342 88.7802 36.4301 88.3132 37.0608 87.8193C37.6916 87.3254 38.4673 86.7188 40.0509 86.7188C41.6344 86.7188 42.5416 87.3039 43.3469 87.8193C44.1521 88.3346 44.8446 88.7802 46.1812 88.7802C47.5179 88.7802 48.1137 88.3132 48.7445 87.8193C49.3752 87.3254 50.1509 86.7188 51.7345 86.7188C53.3181 86.7188 54.228 87.3039 55.0332 87.8193C55.8384 88.3346 56.5282 88.7802 57.8676 88.7802C57.9025 89.0379 57.9427 89.2956 57.9776 89.5533Z" fill="#EBEBEB"/>
<path d="M60.2439 14.8269C59.3367 12.4111 57.2404 10.8247 54.9858 10.8247H50.3907C50.0487 10.8218 49.715 10.7184 49.4311 10.5276C49.1472 10.3367 48.9256 10.0667 48.7937 9.75107C48.4689 8.97957 47.9257 8.31983 47.2309 7.85296C46.5361 7.38609 45.7201 7.13246 44.8831 7.12324C44.0733 7.11503 43.2822 7.36547 42.6246 7.83811C41.9671 8.31075 41.4776 8.98092 41.2274 9.75107C41.1254 10.0662 40.9253 10.3404 40.6563 10.5336C40.3873 10.7268 40.0635 10.8288 39.7324 10.8247H35.14C32.8827 10.8247 30.9394 12.4192 30.2684 14.8269L30 15.7851H60.5982L60.2439 14.8269Z" fill="#263238"/>
<path d="M60.4114 16.7288H30.2964C30.0424 16.7259 29.799 16.6267 29.6152 16.4514C29.4314 16.276 29.3209 16.0376 29.306 15.784C29.2994 15.6621 29.3178 15.5402 29.3601 15.4258C29.4024 15.3113 29.4677 15.2068 29.5519 15.1185C29.6361 15.0302 29.7376 14.9602 29.8499 14.9126C29.9623 14.865 30.0832 14.8409 30.2052 14.8418H60.3202C60.5737 14.8447 60.8168 14.9435 61.0005 15.1183C61.1842 15.293 61.295 15.5309 61.3106 15.784C61.3176 15.906 61.2994 16.0282 61.2573 16.143C61.2152 16.2577 61.15 16.3627 61.0657 16.4512C60.9814 16.5398 60.8799 16.6101 60.7674 16.6578C60.6548 16.7056 60.5337 16.7297 60.4114 16.7288Z" fill="#6287FF"/>
<path opacity="0.2" d="M60.4114 16.7288H30.2964C30.0424 16.7259 29.799 16.6267 29.6152 16.4514C29.4314 16.276 29.3209 16.0376 29.306 15.784C29.2994 15.6621 29.3178 15.5402 29.3601 15.4258C29.4024 15.3113 29.4677 15.2068 29.5519 15.1185C29.6361 15.0302 29.7376 14.9602 29.8499 14.9126C29.9623 14.865 30.0832 14.8409 30.2052 14.8418H60.3202C60.5737 14.8447 60.8168 14.9435 61.0005 15.1183C61.1842 15.293 61.295 15.5309 61.3106 15.784C61.3176 15.906 61.2994 16.0282 61.2573 16.143C61.2152 16.2577 61.15 16.3627 61.0657 16.4512C60.9814 16.5398 60.8799 16.6101 60.7674 16.6578C60.6548 16.7056 60.5337 16.7297 60.4114 16.7288Z" fill="black"/>
<path d="M87.4446 96.1977H85.4772L85.2812 91.6426H87.2487L87.4446 96.1977Z" fill="#FFC3BD"/>
<path d="M99.2559 96.1977H97.2885L96.3008 91.6426H98.2655L99.2559 96.1977Z" fill="#FFC3BD"/>
<path d="M97.1479 95.9688H99.3569C99.3958 95.9685 99.4337 95.9818 99.464 96.0062C99.4943 96.0307 99.5153 96.0648 99.5233 96.103L99.9125 97.8531C99.9213 97.8955 99.9205 97.9394 99.9101 97.9815C99.8998 98.0236 99.8801 98.0629 99.8525 98.0964C99.8249 98.1298 99.7902 98.1567 99.7509 98.175C99.7116 98.1933 99.6687 98.2025 99.6253 98.202C98.855 98.1886 98.4792 98.143 97.5076 98.143C96.909 98.143 95.6771 98.2047 94.8531 98.2047C94.0291 98.2047 93.919 97.3994 94.2572 97.3162C95.7737 96.9834 96.3427 96.5271 96.8285 96.0895C96.9167 96.0117 97.0303 95.9688 97.1479 95.9688Z" fill="#263238"/>
<path d="M85.49 95.9688H87.6373C87.6762 95.9685 87.714 95.9818 87.7444 96.0062C87.7747 96.0307 87.7956 96.0648 87.8037 96.103L88.1928 97.8531C88.2024 97.8941 88.2027 97.9367 88.1938 97.9779C88.1849 98.019 88.1669 98.0577 88.1413 98.0911C88.1156 98.1245 88.0828 98.1517 88.0453 98.1709C88.0078 98.1901 87.9665 98.2007 87.9244 98.202C87.1488 98.1886 86.0295 98.143 85.0552 98.143C83.9172 98.143 82.9348 98.2047 81.5981 98.2047C80.7929 98.2047 80.5675 97.3994 80.9057 97.3162C82.4436 96.978 83.6998 96.9431 85.0284 96.1218C85.1658 96.0304 85.3252 95.9776 85.49 95.9688Z" fill="#263238"/>
<path d="M89.3455 24.4473C89.0771 25.886 88.9214 27.6683 89.9279 28.6292C89.9279 28.6292 89.3509 30.0894 86.6776 30.0894C84.2351 30.0894 85.459 28.6292 85.459 28.6292C87.0694 28.2454 86.9782 26.2618 86.699 25.1398L89.3455 24.4473Z" fill="#FFC3BD"/>
<path d="M84.6914 28.8288C84.7451 28.4718 85.3731 28.0557 86.0871 27.9001C86.8011 27.7444 89.5442 27.3981 90.3816 27.7444C91.219 28.0906 90.2367 29.116 90.2367 29.116L84.6914 28.8288Z" fill="#6287FF"/>
<path opacity="0.4" d="M84.6914 28.8288C84.7451 28.4718 85.3731 28.0557 86.0871 27.9001C86.8011 27.7444 89.5442 27.3981 90.3816 27.7444C91.219 28.0906 90.2367 29.116 90.2367 29.116L84.6914 28.8288Z" fill="white"/>
<path opacity="0.2" d="M85.2812 91.6445L85.3832 93.9905H87.3507L87.2487 91.6445H85.2812Z" fill="black"/>
<path opacity="0.2" d="M98.2682 91.6445H96.3008L96.8107 93.9905H98.7782L98.2682 91.6445Z" fill="black"/>
<path d="M94.0028 30.4004L91.6328 31.9841C91.6328 31.9841 95.0362 38.0369 94.7517 39.0059C94.3625 40.3265 93.8203 43.212 93.0822 44.6776C93.1788 44.9943 93.67 45.7164 93.9438 45.8399C95.8226 44.4119 97.7202 39.9346 97.6505 38.6811C97.4867 35.8386 94.0028 30.4004 94.0028 30.4004Z" fill="#FFC3BD"/>
<path d="M93.0781 44.6821L91.1992 44.5371L92.1843 46.6066C92.1843 46.6066 93.8242 46.6791 94.098 45.4256L93.0781 44.6821Z" fill="#B55B52"/>
<path d="M102.364 54.7739L102.205 55.0718L101.143 57.0823L63.4102 37.1307L64.6287 34.8223L102.364 54.7739Z" fill="#6287FF"/>
<path d="M104.805 50.164L104.027 51.6349L103.587 52.467L65.8516 32.5154L67.0701 30.207L104.805 50.164Z" fill="#6287FF"/>
<path d="M65.8696 32.5109L64.6484 34.8164L102.368 54.7974L103.589 52.4918L65.8696 32.5109Z" fill="#6287FF"/>
<path opacity="0.2" d="M65.8696 32.5109L64.6484 34.8164L102.368 54.7974L103.589 52.4918L65.8696 32.5109Z" fill="black"/>
<path d="M61.7853 30.5162L60.6875 32.5938L63.4118 37.1327L67.0702 30.2129L61.7853 30.5162Z" fill="#6287FF"/>
<path opacity="0.8" d="M61.7853 30.5162L60.6875 32.5938L63.4118 37.1327L67.0702 30.2129L61.7853 30.5162Z" fill="white"/>
<path d="M59.5234 30.6452L60.691 32.5912L61.7888 30.5137L59.5234 30.6452Z" fill="#6287FF"/>
<path d="M89.6914 45.4793L90.6738 47.3099L92.1956 46.6066L91.2106 44.5371L89.6914 45.4793Z" fill="#B55B52"/>
<path d="M93.4427 29.0712C95.3027 29.3396 97.4339 35.7817 97.4339 35.7817L93.5259 37.9881C93.5259 37.9881 91.8054 34.9334 90.96 32.6519C90.0689 30.2656 91.4485 28.7813 93.4427 29.0712Z" fill="#263238"/>
<path opacity="0.2" d="M92.3572 31.2846C91.5117 30.5116 92.0297 33.8212 92.4323 35.939C92.639 36.3524 92.8349 36.7282 93.0013 37.0422C93.9434 35.378 93.522 32.3503 92.3572 31.2846Z" fill="black"/>
<path d="M82.4232 29.1765C82.4232 29.1765 80.1015 35.1139 82.3051 46.1728H92.8347C92.9071 44.5623 91.8926 36.6815 93.4493 29.0745C92.2864 28.85 91.1101 28.7011 89.9278 28.6289C88.4394 28.543 86.9473 28.543 85.4589 28.6289C84.4342 28.7314 83.4192 28.9145 82.4232 29.1765Z" fill="#263238"/>
<path d="M84.0442 31.9362L81.3924 30.8867C81.3924 30.8867 78.338 37.1221 77.3663 37.4361C76.0592 37.8656 73.3752 39.0467 71.7486 39.2775C71.5446 39.5459 71.2279 40.3512 71.2789 40.6464C73.5201 41.3792 78.2897 40.4076 79.2774 39.6399C81.5427 37.8898 84.0442 31.9362 84.0442 31.9362Z" fill="#FFC3BD"/>
<path opacity="0.2" d="M84.3401 31.2258C83.9026 30.2165 83.0651 29.7951 82.1928 29.9427C81.8546 31.1802 81.2829 33.8992 81.3876 37.9953L82.013 38.296C82.013 38.296 85.0889 32.9517 84.3401 31.2258Z" fill="black"/>
<path d="M84.7595 30.5172C85.4198 32.278 82.0754 37.4585 82.0754 37.4585L78.1406 35.3112C78.7318 33.6999 79.4939 32.1566 80.414 30.7078C81.7963 28.6436 84.0321 28.5873 84.7595 30.5172Z" fill="#263238"/>
<path d="M71.8405 39.2695L69.5 39.7661L70.6863 41.9323C71.3405 41.6068 71.9349 41.173 72.4444 40.6492L71.8405 39.2695Z" fill="#FFC3BD"/>
<path d="M68.3984 40.2578L69.3325 41.5516L70.6906 41.9435L69.5043 39.7773L68.3984 40.2578Z" fill="#FFC3BD"/>
<path d="M84.8858 22.378C84.8858 22.5364 84.7865 22.6464 84.6818 22.6464C84.5772 22.6464 84.502 22.5069 84.5127 22.3485C84.5235 22.1901 84.6121 22.0801 84.7167 22.0801C84.8214 22.0801 84.8966 22.2197 84.8858 22.378Z" fill="#263238"/>
<path d="M85.0222 22.3887C84.8055 22.8616 84.5246 23.3024 84.1875 23.6986C84.2911 23.7824 84.4119 23.8425 84.5413 23.8745C84.6707 23.9065 84.8056 23.9096 84.9363 23.8838L85.0222 22.3887Z" fill="#ED847E"/>
<path d="M84.6846 21.8293C84.6703 21.8263 84.6567 21.8208 84.6443 21.8132C84.6339 21.8067 84.6249 21.7981 84.6179 21.788C84.6109 21.7779 84.606 21.7665 84.6035 21.7545C84.601 21.7425 84.6009 21.73 84.6033 21.718C84.6057 21.7059 84.6106 21.6945 84.6175 21.6843C84.6953 21.5587 84.8017 21.4532 84.9282 21.3767C85.0546 21.3002 85.1974 21.2547 85.3449 21.2441C85.3694 21.2454 85.3925 21.2557 85.4099 21.2731C85.4272 21.2904 85.4375 21.3136 85.4388 21.3381C85.4388 21.363 85.4289 21.3869 85.4113 21.4045C85.3937 21.4221 85.3698 21.432 85.3449 21.432C85.2304 21.4427 85.12 21.4801 85.0226 21.5411C84.9252 21.6022 84.8434 21.6853 84.7839 21.7837C84.7742 21.8007 84.7594 21.8142 84.7416 21.8224C84.7238 21.8306 84.7038 21.833 84.6846 21.8293Z" fill="#263238"/>
<path d="M90.2236 22.2421C89.9928 24.1801 89.9552 25.3235 88.9165 26.2684C87.3517 27.6856 85.0032 26.6576 84.6489 24.6874C84.3321 22.9158 84.7643 20.0464 86.7129 19.3807C87.1417 19.2324 87.6013 19.1961 88.048 19.2752C88.4948 19.3544 88.9139 19.5464 89.2656 19.833C89.6173 20.1197 89.8899 20.4915 90.0576 20.9131C90.2253 21.3347 90.2824 21.7922 90.2236 22.2421Z" fill="#FFC3BD"/>
<path d="M86.319 22.6182C85.6399 22.7524 84.5556 21.2439 85.4413 19.9635C84.9931 19.7407 83.5302 20.6212 82.98 19.7998C82.4298 18.9784 83.957 18.5409 83.6644 17.8457C84.7005 18.0578 82.9934 19.3515 83.9785 19.2254C84.9635 19.0992 86.0989 17.2793 87.1993 18.0255C89.1453 19.3327 91.7971 17.1532 90.7154 19.883C92.0414 19.6146 92.9486 21.1822 91.6844 22.2693C89.1641 24.43 90.7154 24.7146 89.1184 24.8246C88.3186 24.8837 86.4585 23.9308 86.319 22.6182Z" fill="#263238"/>
<path d="M87.3248 23.1269C87.2319 23.3207 87.1011 23.4939 86.9403 23.6363C86.7794 23.7788 86.5916 23.8876 86.3881 23.9563C85.8513 24.1415 85.5426 23.6611 85.6687 23.1323C85.7815 22.6545 86.2055 21.9835 86.7611 22.0318C86.8831 22.0437 87.0001 22.086 87.1015 22.1548C87.2028 22.2236 87.2853 22.3168 87.3414 22.4257C87.3975 22.5347 87.4253 22.6559 87.4224 22.7784C87.4195 22.9009 87.386 23.0207 87.3248 23.1269Z" fill="#FFC3BD"/>
<path d="M86.0391 46.1719C86.0391 46.1719 88.2722 61.2034 89.4961 66.8402C90.8381 73.0138 95.8922 93.5452 95.8922 93.5452H99.4942C99.4942 93.5452 96.1633 73.505 95.3957 67.3985C94.5663 60.7739 92.827 46.1799 92.827 46.1799L86.0391 46.1719Z" fill="#6287FF"/>
<path opacity="0.2" d="M86.0391 46.1719C86.0391 46.1719 88.2722 61.2034 89.4961 66.8402C90.8381 73.0138 95.8922 93.5452 95.8922 93.5452H99.4942C99.4942 93.5452 96.1633 73.505 95.3957 67.3985C94.5663 60.7739 92.827 46.1799 92.827 46.1799L86.0391 46.1719Z" fill="white"/>
<path opacity="0.2" d="M88.6869 51.4283C88.5205 51.1921 88.3702 51.1116 88.2307 51.1599H88.2011C88.1694 51.1738 88.1396 51.1918 88.1126 51.2136C88.084 51.2368 88.0579 51.2629 88.0347 51.2914L87.9918 51.3451L87.9354 51.4337C87.8888 51.5118 87.8484 51.5935 87.8146 51.6779C87.7932 51.7289 87.7717 51.7826 87.7529 51.8363C87.7341 51.89 87.7046 51.9732 87.6831 52.0484C87.6616 52.1235 87.6214 52.2524 87.5919 52.3624C87.5919 52.3919 87.5784 52.4188 87.5704 52.4483C87.5623 52.4778 87.5409 52.5718 87.5274 52.6335C87.514 52.6953 87.5033 52.7409 87.4926 52.7946C87.4684 52.8993 87.4469 53.0093 87.4255 53.122C87.404 53.2348 87.3798 53.3663 87.3583 53.4925C87.3583 53.5354 87.3449 53.5784 87.3369 53.624C87.31 53.785 87.2859 53.9488 87.2617 54.1179C87.8576 57.8596 88.5662 62.149 89.1406 65.1419C89.1674 65.0452 89.1969 64.9432 89.2211 64.8332C89.3383 64.3339 89.4279 63.8285 89.4895 63.3193C89.9968 59.4621 89.7633 52.9664 88.6869 51.4283Z" fill="black"/>
<path d="M82.3059 46.1719C82.3059 46.1719 82.0375 60.8759 82.2495 66.8751C82.4723 73.1131 84.6518 93.5372 84.6518 93.5372H87.9827C87.9827 93.5372 88.1034 73.4755 88.2511 67.3502C88.4121 60.6719 89.2173 46.1719 89.2173 46.1719H82.3059Z" fill="#6287FF"/>
<path opacity="0.2" d="M82.3059 46.1719C82.3059 46.1719 82.0375 60.8759 82.2495 66.8751C82.4723 73.1131 84.6518 93.5372 84.6518 93.5372H87.9827C87.9827 93.5372 88.1034 73.4755 88.2511 67.3502C88.4121 60.6719 89.2173 46.1719 89.2173 46.1719H82.3059Z" fill="white"/>
<path d="M88.2011 92.519C88.2146 92.519 88.2011 93.6061 88.2011 93.6061H84.3603L84.1992 92.3848L88.2011 92.519Z" fill="#263238"/>
<path d="M99.4913 92.5988C99.5074 92.5988 99.6712 93.6054 99.6712 93.6054H95.7122L95.3633 92.4512L99.4913 92.5988Z" fill="#263238"/>
<path d="M96.4974 96.3142C96.3636 96.325 96.2301 96.29 96.1189 96.2148C96.0828 96.1856 96.0549 96.1474 96.038 96.1041C96.0211 96.0608 96.0156 96.0139 96.0223 95.9679C96.0226 95.9411 96.03 95.9148 96.0436 95.8917C96.0573 95.8686 96.0768 95.8495 96.1001 95.8364C96.3175 95.7263 96.9537 96.1048 97.0261 96.1585C97.0335 96.1639 97.0392 96.1713 97.0426 96.1799C97.0459 96.1884 97.0467 96.1978 97.0449 96.2068C97.0435 96.2158 97.0395 96.2242 97.0333 96.2309C97.027 96.2376 97.0189 96.2423 97.01 96.2444C96.8422 96.2863 96.6703 96.3097 96.4974 96.3142ZM96.2048 95.9088C96.1845 95.9043 96.1634 95.9043 96.1431 95.9088C96.1337 95.9142 96.126 95.9221 96.1208 95.9316C96.1156 95.941 96.1131 95.9517 96.1136 95.9625C96.1094 95.9938 96.1132 96.0257 96.1244 96.0552C96.1357 96.0847 96.1541 96.111 96.178 96.1316C96.3971 96.2334 96.647 96.2469 96.8758 96.1692C96.671 96.04 96.4432 95.9516 96.2048 95.9088Z" fill="#6287FF"/>
<path d="M96.994 96.2445C96.987 96.2467 96.9795 96.2467 96.9725 96.2445C96.7686 96.1344 96.3767 95.7076 96.4169 95.4848C96.4238 95.4507 96.4422 95.42 96.4691 95.398C96.4961 95.376 96.5298 95.364 96.5646 95.364C96.6 95.3587 96.6361 95.3612 96.6704 95.3715C96.7048 95.3817 96.7364 95.3993 96.7632 95.4231C96.9913 95.6083 97.0316 96.1773 97.0316 96.2015C97.0314 96.2098 97.0294 96.218 97.0257 96.2254C97.0219 96.2328 97.0166 96.2393 97.0101 96.2445C97.0048 96.2454 96.9993 96.2454 96.994 96.2445ZM96.5968 95.4392H96.5887C96.527 95.4392 96.5216 95.4741 96.5189 95.4875C96.4948 95.6164 96.7444 95.9411 96.9484 96.0941C96.9343 95.8704 96.8529 95.6561 96.7149 95.4795C96.6977 95.4647 96.6775 95.4539 96.6557 95.4478C96.6339 95.4418 96.611 95.4407 96.5887 95.4446L96.5968 95.4392Z" fill="#6287FF"/>
<path d="M84.6744 96.3134C84.506 96.3291 84.3374 96.2864 84.1967 96.1926C84.1657 96.1643 84.1419 96.1292 84.127 96.0901C84.112 96.0509 84.1065 96.0088 84.1108 95.9671C84.1108 95.9417 84.1179 95.9167 84.1311 95.8949C84.1444 95.8731 84.1633 95.8554 84.1859 95.8437C84.4248 95.7095 85.2166 96.1121 85.3052 96.1577C85.3141 96.1618 85.3214 96.1688 85.3258 96.1776C85.3302 96.1864 85.3314 96.1964 85.3293 96.206C85.3282 96.2156 85.3239 96.2245 85.3171 96.2313C85.3102 96.2381 85.3013 96.2425 85.2918 96.2436C85.0888 96.2869 84.882 96.3103 84.6744 96.3134ZM84.3175 95.9081C84.288 95.9069 84.2586 95.9124 84.2316 95.9242C84.2226 95.9294 84.2152 95.9368 84.21 95.9457C84.2048 95.9547 84.2021 95.9648 84.202 95.9752C84.1982 96.0026 84.2014 96.0304 84.2112 96.0563C84.2211 96.0821 84.2373 96.105 84.2584 96.1228C84.3792 96.2302 84.704 96.249 85.1388 96.1765C84.882 96.0416 84.6043 95.9509 84.3175 95.9081Z" fill="#6287FF"/>
<path d="M85.2818 96.2461H85.263C85.0241 96.1387 84.5544 95.7093 84.592 95.4919C84.592 95.4409 84.6376 95.3737 84.7637 95.363C84.8114 95.3559 84.8601 95.3592 84.9064 95.3727C84.9528 95.3861 84.9956 95.4093 85.0322 95.4409C85.2818 95.6475 85.3328 96.1763 85.3354 96.2005C85.3366 96.2083 85.3355 96.2163 85.3321 96.2234C85.3288 96.2306 85.3234 96.2366 85.3167 96.2407C85.3061 96.2469 85.2937 96.2488 85.2818 96.2461ZM84.8013 95.4409H84.7825C84.6993 95.4409 84.694 95.4811 84.6913 95.4945C84.6698 95.6261 84.9892 95.9616 85.2281 96.1065C85.2049 95.8811 85.1109 95.6687 84.9597 95.4999C84.914 95.4656 84.8585 95.4468 84.8013 95.4462V95.4409Z" fill="#6287FF"/>
</svg>
`,
            },
          },
        },
      },
      components: {
        directory: {
          header: {
            directory: {
              'header.module.css': {
                file: {
                  contents: `.header {
    background: #222222;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.6rem;
    height: 25rem;
    position: fixed;
    width: 100vw;
    z-index: 2;
}

.newTaskForm {
    position: absolute;
    bottom: -2.7rem;
    width: 100%;
    max-width: 55%;
    display: flex;
    gap: 1rem;
    padding: 0 1rem;
    height: 100%;
    align-items: flex-end;
}

.newTaskForm input {
    height: 5.4rem;
    flex: 1;
    color: #fff;
    background: #262626;
    border: 1px solid #8d8d8d;
    border-radius: 5px;
    padding: 0 1.6rem;
    font-size: 1.6rem;
}

.newTaskForm input:focus {
    outline: none;
}

.newTaskForm input::placeholder {
    letter-spacing: 1.5px;
}

.newTaskForm button {
    height: 5.4rem;
    padding: 0 2.4rem;
    background: #6287ff;
    color: #fff;
    border: none;
    border-radius: 5px;
    display: flex;
    gap: 1rem;
    align-items: center;
    justify-content: center;
    font-size: 1.4rem;
    font-weight: 600;
    letter-spacing: 0.6px;
}

@media screen and (max-width: 1024px) {
    .newTaskForm {
        max-width: 70%;
    }
}

@media screen and (max-width: 670px) {
    .newTaskForm {
        max-width: 80%;
    }
}

@media screen and (max-width: 470px) {
    .newTaskForm {
        padding: 0;
    }

    .newTaskForm input {
        font-size: 1.4rem;
    }

    .newTaskForm button {
        font-size: 1.2rem;
        padding: 0 1.4rem;
    }
}

@media screen and (max-width: 425px) {
    .header img {
        width: 40%;
    }

    .newTaskForm {
        max-width: 95%;
        gap: 1rem;
        flex-direction: column;
        height: 40%;
        align-items: center;
    }

    .newTaskForm input {
        width: 80%;
    }

    .newTaskForm button {
        padding: 0 1rem;
        gap: 0.5rem;
        width: 30%;
        margin: 0 auto;
        height: 4.2rem;
    }
}

@media screen and (max-width: 380px) {
    .header img {
        width: 25%;
    }

    .newTaskForm {
        padding: 0;
        max-width: 85%;
    }
}

@media screen and (max-width: 370px) {
    .newTaskForm {
        max-width: 90%;
    }
}

@media screen and (max-width: 350px) {
    .newTaskForm {
        max-width: 95%;
        gap: 0.5rem;
    }

    .newTaskForm button {
        padding: 0 1rem;
    }
}

@media screen and (max-width: 320px) {
    .newTaskForm {
        max-width: 95%;
        gap: 0.5rem;
        flex-direction: column;
        height: 40%;
        align-items: center;
    }

    .newTaskForm input {
        width: 80%;
    }

    .newTaskForm button {
        padding: 0 1rem;
        gap: 0.5rem;
        width: 35%;
        margin: 0 auto;
        height: 4.2rem;
    }
}`,
                },
              },
              'index.jsx': {
                file: {
                  contents: `/* eslint-disable react/prop-types */
import todo from '../../assets/todo.svg'
import { AiOutlinePlusCircle } from "react-icons/ai";
import styles from './header.module.css';
import { useState } from 'react';

export function Header({ onAddTask }) {

    const [title, setTitle] = useState('')

    function handleSubmit(event) {
        event.preventDefault()
        if (title == '') {
            return null;
        } else {
            onAddTask(title)
            setTitle('')
        }
    }

    function onChangeTitle(event) {
        setTitle(event.target.value)
    }

    return (
        <header className={styles.header}>
            <img src={todo} alt="" />

            <form onSubmit={handleSubmit} className={styles.newTaskForm}>
                <input type="text" placeholder='Add a New Task' value={title} onChange={onChangeTitle} />
                <button>
                    Create
                    <AiOutlinePlusCircle size={22} />
                </button>
            </form>
        </header>
    )
}`,
                },
              },
            },
          },
          task: {
            directory: {
              'task.module.css': {
                file: {
                  contents: `.task {
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: space-between;
    background: #222222;
    padding: 2rem;
    border-radius: 5px;
    gap: 2rem;
}

.checkContainer {
    width: 2rem;
    height: 2rem;
    background: none;
    border: none;
}

.checkContainer div {
    width: 100%;
    height: 100%;
    border: 2px solid #6287ff;
    border-radius: 50%;
}

.checkContainer svg {
    width: 100%;
    height: 100%;
    color: #6287ff;
}

.task p {
    font-size: 1.4rem;
    line-height: 2rem;
    color: #fff;
    margin-right: auto;
}

p.taskCompleted {
    color: #6d6d6d;
    text-decoration: line-through;
}

.delBtn {
    background: none;
    border: none;
    color: #dadada;
}`,
                },
              },
              'index.jsx': {
                file: {
                  contents: `/* eslint-disable react/prop-types */
import styles from './task.module.css'
import { AiFillDelete, AiFillCheckCircle } from "react-icons/ai";

export function Task({ task, onComplete, onDelete }) {
    return (
        <div className={styles.task}>
            <button className={styles.checkContainer} onClick={() => onComplete(task.id)}>
                {task.isCompleted ? <AiFillCheckCircle /> : < div />}
            </button>
            <p className={task.isCompleted ? styles.taskCompleted : ""}>{task.title}</p>
            <button className={styles.delBtn} onClick={() => onDelete(task.id)}>
                <AiFillDelete size={28} />
            </button>
        </div>
    )
}`,
                },
              },
            },
          },
          tasks: {
            directory: {
              'tasks.module.css': {
                file: {
                  contents: `.tasks {
    display: flex;
    flex-direction: column;
    gap: 5rem;
    padding: 10rem 0rem;
    width: 100%;
    max-width: 50%;
    margin: 0px auto;
}

.header {
    display: flex;
    justify-content: space-between;
    align-self: center;
    justify-self: center;
    width: 100%;
    position: fixed;
    max-width: 60%;
    margin: 0 auto;
    top: 25rem;
    backdrop-filter: blur(2rem);
    padding: 10rem 5rem 0;
    z-index: 1;
}

.header div {
    display: flex;
    gap: 1rem;
    justify-content: center;
    align-items: center;
}

.header div p {
    font-size: 1.8rem;
    color: #6287ff;
    font-weight: 600;
    letter-spacing: 1px;
}

.header div .completed {
    font-size: 1.8rem;
    color: #dadada;
    font-weight: 600;
    letter-spacing: 1px;
}

.header div span {
    font-size: 1.4rem;
    font-weight: 500;
    letter-spacing: 0.5px;
    color: #1b1b1b;
    padding: 0.2rem 1rem;
    background: #fff;
    border-radius: 5px;
}

.list {
    width: 100%;
    display: flex;
    flex-direction: column;
    gap: 1.4rem;
    margin-top: 32rem;
}

@media screen and (max-width: 1024px) {
    .header {
        max-width: 70%;
    }

    .tasks {
        max-width: 60%;
    }
}

@media screen and (max-width: 768px) {
    .header div p {
        font-size: 1.4rem;
    }

    .header div .completed {
        font-size: 1.4rem;
    }

    .header div span {
        font-size: 1.2rem;
    }
}

@media screen and (max-width: 670px) {
    .header {
        max-width: 80%;
    }

    .tasks {
        max-width: 70%;
    }
}

@media screen and (max-width: 575px) {
    .header {
        max-width: 90%;
    }

    .tasks {
        max-width: 70%;
    }
}

@media screen and (max-width: 510px) {
    .header div p {
        font-size: 1.2rem;
    }

    .header div .completed {
        font-size: 1.2rem;
    }

    .header div span {
        font-size: 1rem;
    }
}

@media screen and (max-width: 470px) {

    .header {
        top: 22rem;
    }

    .header div {
        flex-direction: column;
    }
}

@media screen and (max-width: 380px) {
    .header {
        padding: 10rem 2rem 0;
    }

    .tasks {
        max-width: 80%;
    }
}`,
                },
              },
              'index.jsx': {
                file: {
                  contents: `/* eslint-disable react/prop-types */
import styles from './tasks.module.css';
import { Task } from '../task';

export function Tasks({ tasks, onComplete, onDelete }) {

    const tasksQuantity = tasks.length
    const completedTask = tasks.filter(task => task.isCompleted).length

    return (
        <section className={styles.tasks}>
            <header className={styles.header}>
                <div>
                    <p>Created Task</p>
                    <span>{tasksQuantity}</span>
                </div>
                <div>
                    <p className={styles.completed}>Completed Tasks</p>
                    <span>{completedTask} of {tasksQuantity}</span>
                </div>
            </header>

            <div className={styles.list}>
                {tasks.map(task => (
                    <Task key={task.id} task={task} onComplete={onComplete} onDelete={onDelete} />
                ))}
            </div>
        </section>
    )
}`,
                },
              },
            },
          },
        },
      },
      styles: {
        directory: {
          'global.css': {
            file: {
              contents: `@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800;900&display=swap');

* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
  font-family: 'Poppins', sans-serif;
}

html {
  font-size: 62.5%;
}

body {
  background: #191919;
  color: #f2f2f2;
  min-height: 100vh;
  overflow-y: scroll;
}

button {
  cursor: pointer;
}`,
            },
          },
        },
      },
      'App.jsx': {
        file: {
          contents: `import { useEffect, useState } from "react";
import { Header } from "./components/header";
import { Tasks } from "./components/tasks";

const LOCAL_STORAGE_KEY = "todo:savedTasks"

function App() {

  const [tasks, setTasks] = useState([])

  function loadSavedTasks() {
    const saved = localStorage.getItem(LOCAL_STORAGE_KEY)
    if (saved) {
      setTasks(JSON.parse(saved))
    }
  }

  useEffect(() => {
    loadSavedTasks()
  }, [])

  function setTaskAndSave(newTasks) {
    setTasks(newTasks)
    localStorage.setItem(LOCAL_STORAGE_KEY, JSON.stringify(newTasks))
  }

  function addTask(taskTitle) {
    setTaskAndSave([
      ...tasks,
      {
        id: crypto.randomUUID(),
        title: taskTitle,
        isCompleted: false
      }
    ])
  }

  function toggleTaskCompletedById(taskId) {
    const newTasks = tasks.map(task => {
      if (task.id === taskId) {
        return { ...task, isCompleted: !task.isCompleted }
      }
      return task
    })
    setTaskAndSave(newTasks)
  }

  function deleteTaskById(taskId) {
    const newTasks = tasks.filter(task => task.id != taskId)
    setTaskAndSave(newTasks)
  }

  return (
    <>
      <Header onAddTask={addTask} />
      <Tasks
        tasks={tasks}
        onComplete={toggleTaskCompletedById}
        onDelete={deleteTaskById}
      />
    </>
  )
}

export default App
`,
        },
      },
      'main.jsx': {
        file: {
          contents: `import React from 'react'
import ReactDOM from 'react-dom/client'
import App from './App.jsx'
import './styles/global.css'

ReactDOM.createRoot(document.getElementById('root')).render(
  <React.StrictMode>
    <App />
  </React.StrictMode>,
)
`,
        },
      },
    },
  },
  'eslintrc.cjs': {
    file: {
      contents: `module.exports = {
  root: true,
  env: { browser: true, es2020: true },
  extends: [
    'eslint:recommended',
    'plugin:react/recommended',
    'plugin:react/jsx-runtime',
    'plugin:react-hooks/recommended',
  ],
  ignorePatterns: ['dist', '.eslintrc.cjs'],
  parserOptions: { ecmaVersion: 'latest', sourceType: 'module' },
  settings: { react: { version: '18.2' } },
  plugins: ['react-refresh'],
  rules: {
    'react-refresh/only-export-components': [
      'warn',
      { allowConstantExport: true },
    ],
  },
}
`,
    },
  },
  'index.html': {
    file: {
      contents: `<!doctype html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <link rel="icon" type="image/png" href="/src/assets/todo-favicon.png" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>ToDO App</title>
</head>

<body>
  <div id="root"></div>
  <script type="module" src="/src/main.jsx"></script>
</body>

</html>`,
    },
  },
  'package.json': {
    file: {
      contents: `{
  "name": "to-do-app",
  "private": true,
  "version": "0.0.0",
  "type": "module",
  "scripts": {
    "dev": "vite",
    "build": "vite build",
    "lint": "eslint . --ext js,jsx --report-unused-disable-directives --max-warnings 0",
    "preview": "vite preview"
  },
  "dependencies": {
    "react": "^18.2.0",
    "react-dom": "^18.2.0",
    "react-icons": "^4.10.1"
  },
  "devDependencies": {
    "@types/react": "^18.2.15",
    "@types/react-dom": "^18.2.7",
    "@vitejs/plugin-react": "^4.0.3",
    "eslint": "^8.45.0",
    "eslint-plugin-react": "^7.32.2",
    "eslint-plugin-react-hooks": "^4.6.0",
    "eslint-plugin-react-refresh": "^0.4.3",
    "vite": "^4.4.5"
  }
}
`,
    },
  },
  'vite.config.js': {
    file: {
      contents: `import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [react()],
  base: "/todo-app"
})
`,
    },
  },
}
